/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.params.ArgumentCountValidationMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.ParameterizedTestMethodContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.Preconditions;

class ArgumentCountValidator
implements InvocationInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(ArgumentCountValidator.class);
    static final String ARGUMENT_COUNT_VALIDATION_KEY = "junit.jupiter.params.argumentCountValidation";
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{ArgumentCountValidator.class});
    private final ParameterizedTestMethodContext methodContext;
    private final Arguments arguments;

    ArgumentCountValidator(ParameterizedTestMethodContext methodContext, Arguments arguments) {
        this.methodContext = methodContext;
        this.arguments = arguments;
    }

    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.validateArgumentCount(extensionContext, this.arguments);
        invocation.proceed();
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(NAMESPACE);
    }

    private void validateArgumentCount(ExtensionContext extensionContext, Arguments arguments) {
        ArgumentCountValidationMode argumentCountValidationMode = this.getArgumentCountValidationMode(extensionContext);
        switch (argumentCountValidationMode) {
            case DEFAULT: 
            case NONE: {
                return;
            }
            case STRICT: {
                int testParamCount = extensionContext.getRequiredTestMethod().getParameterCount();
                int argumentsCount = arguments.get().length;
                Preconditions.condition((testParamCount == argumentsCount ? 1 : 0) != 0, () -> String.format("Configuration error: the @ParameterizedTest has %s argument(s) but there were %s argument(s) provided.%nNote: the provided arguments are %s", testParamCount, argumentsCount, Arrays.toString(arguments.get())));
                break;
            }
            default: {
                throw new ExtensionConfigurationException("Unsupported argument count validation mode: " + (Object)((Object)argumentCountValidationMode));
            }
        }
    }

    private ArgumentCountValidationMode getArgumentCountValidationMode(ExtensionContext extensionContext) {
        ParameterizedTest parameterizedTest = this.methodContext.annotation;
        if (parameterizedTest.argumentCountValidation() != ArgumentCountValidationMode.DEFAULT) {
            return parameterizedTest.argumentCountValidation();
        }
        return this.getArgumentCountValidationModeConfiguration(extensionContext);
    }

    private ArgumentCountValidationMode getArgumentCountValidationModeConfiguration(ExtensionContext extensionContext) {
        String key = ARGUMENT_COUNT_VALIDATION_KEY;
        ArgumentCountValidationMode fallback = ArgumentCountValidationMode.NONE;
        ExtensionContext.Store store = this.getStore(extensionContext);
        return (ArgumentCountValidationMode)((Object)store.getOrComputeIfAbsent((Object)key, __ -> {
            Optional optionalConfigValue = extensionContext.getConfigurationParameter(key);
            if (optionalConfigValue.isPresent()) {
                String configValue = (String)optionalConfigValue.get();
                Optional<ArgumentCountValidationMode> enumValue = Arrays.stream(ArgumentCountValidationMode.values()).filter(mode -> mode.name().equalsIgnoreCase(configValue)).findFirst();
                if (enumValue.isPresent()) {
                    logger.config(() -> String.format("Using ArgumentCountValidationMode '%s' set via the '%s' configuration parameter.", ((ArgumentCountValidationMode)((Object)((Object)((Object)enumValue.get())))).name(), key));
                    return enumValue.get();
                }
                logger.warn(() -> String.format("Invalid ArgumentCountValidationMode '%s' set via the '%s' configuration parameter. Falling back to the %s default value.", configValue, key, fallback.name()));
                return fallback;
            }
            return fallback;
        }, ArgumentCountValidationMode.class));
    }
}

