/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.menus;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.parsley.edit.actionbar.LightweightActionBarContributor;
import org.eclipse.emf.parsley.edit.actionbar.WorkbenchActionBarContributor;
import org.eclipse.emf.parsley.viewers.ViewerSelectionProvider;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPart;

public class ViewerContextMenuHelper {
    @Inject
    private Provider<LightweightActionBarContributor> lightweightActionBarContributorProvider;
    @Inject
    private Provider<WorkbenchActionBarContributor> workbenchActionBarContributorProvider;

    protected MenuManager createMenuManager() {
        MenuManager menuManager = new MenuManager("#PopUp");
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.setRemoveAllWhenShown(true);
        return menuManager;
    }

    public void addViewerContextMenu(Viewer viewer, IWorkbenchPart activePart, IMenuListener menuListener, WorkbenchActionBarContributor workbenchActionBarContributor) {
        MenuManager menuManager = this.createContextMenu(viewer);
        menuManager.addMenuListener(menuListener);
        this.setupWorkbenchActionBarContributorContextMenu(viewer, activePart, workbenchActionBarContributor, menuManager);
    }

    public void addViewerContextMenu(StructuredViewer viewer, IWorkbenchPart activePart) {
        WorkbenchActionBarContributor workbenchActionBarContributor = (WorkbenchActionBarContributor)((Object)this.workbenchActionBarContributorProvider.get());
        MenuManager menuManager = this.createContextMenu((Viewer)viewer, workbenchActionBarContributor);
        this.setupWorkbenchActionBarContributorContextMenu((Viewer)viewer, activePart, workbenchActionBarContributor, menuManager);
    }

    private void setupWorkbenchActionBarContributorContextMenu(Viewer viewer, IWorkbenchPart activePart, WorkbenchActionBarContributor workbenchActionBarContributor, MenuManager menuManager) {
        activePart.getSite().registerContextMenu(menuManager, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        this.bridgeSelectionProviderAndActionBarContributor(viewer, workbenchActionBarContributor);
        workbenchActionBarContributor.setActivePart(activePart);
    }

    private void bridgeSelectionProviderAndActionBarContributor(Viewer viewer, WorkbenchActionBarContributor actionBarContributor) {
        ViewerSelectionProvider viewerSelectionProvider = new ViewerSelectionProvider(viewer);
        actionBarContributor.setExplicitSelectionProvider(viewerSelectionProvider);
        viewerSelectionProvider.addSelectionChangedListener(actionBarContributor);
    }

    public void addViewerContextMenu(StructuredViewer viewer) {
        this.addViewerContextMenu((Viewer)viewer, null);
    }

    public void addViewerContextMenu(Viewer viewer, EditingDomain editingDomain) {
        LightweightActionBarContributor lightweightActionBarContributor = (LightweightActionBarContributor)this.lightweightActionBarContributorProvider.get();
        this.createContextMenu(viewer, lightweightActionBarContributor);
        viewer.addSelectionChangedListener((ISelectionChangedListener)lightweightActionBarContributor);
        lightweightActionBarContributor.initialize(editingDomain);
    }

    private MenuManager createContextMenu(Viewer viewer) {
        MenuManager menuManager = this.createMenuManager();
        Menu menu = menuManager.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        return menuManager;
    }

    private MenuManager createContextMenu(Viewer viewer, IMenuListener menuListener) {
        MenuManager menuManager = this.createContextMenu(viewer);
        menuManager.addMenuListener(arg_0 -> ((IMenuListener)menuListener).menuAboutToShow(arg_0));
        return menuManager;
    }
}

