/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobFunction;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.pde.ui.target.ITargetLocationHandler;

public class UpdateTargetJob
extends Job {
    private final IJobFunction action;
    private final boolean update;
    private final Job cancelJob;

    public static Job update(ITargetDefinition definition, ITargetLocationHandler handler, TreePath[] treePaths, IJobChangeListener listener, Job cancelJob) {
        UpdateTargetJob job = new UpdateTargetJob(cancelJob, monitor -> handler.update(definition, treePaths, monitor), true);
        job.setUser(true);
        if (listener != null) {
            job.addJobChangeListener(listener);
        }
        job.schedule();
        return job;
    }

    public static Job refresh(ITargetDefinition definition, ITargetLocationHandler handler, IJobChangeListener listener, Job cancelJob) {
        UpdateTargetJob job = new UpdateTargetJob(cancelJob, monitor -> handler.reload(definition, definition.getTargetLocations(), monitor), false);
        job.setUser(true);
        if (listener != null) {
            job.addJobChangeListener(listener);
        }
        job.schedule();
        return job;
    }

    private UpdateTargetJob(Job cancelJob, IJobFunction updateActions, boolean update) {
        super(update ? Messages.UpdateTargetJob_UpdateJobName : Messages.UpdateTargetJob_RefreshJobName);
        this.cancelJob = cancelJob;
        this.action = updateActions;
        this.update = update;
    }

    protected IStatus run(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)(this.update ? Messages.UpdateTargetJob_UpdatingTarget : Messages.UpdateTargetJob_RefreshingTarget), (int)100);
        if (this.cancelJob != null) {
            this.cancelJob.cancel();
            try {
                this.cancelJob.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.action.run((IProgressMonitor)progress);
    }
}

