/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.connector.local.launcher;

import java.util.HashMap;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.terminal.connector.local.activator.UIPlugin;
import org.eclipse.terminal.view.ui.launcher.ILauncherDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;

public class LocalLauncherHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = this.selection(event);
        Optional<ILauncherDelegate> delegate = UIPlugin.getLaunchDelegateManager().getApplicableLauncherDelegates(selection).filter(d -> "org.eclipse.terminal.connector.local.launcher.local".equals(d.getId())).findFirst();
        if (delegate.isPresent()) {
            this.executeDelegate(selection, delegate.get());
        }
        return null;
    }

    private ISelection selection(ExecutionEvent event) {
        IPath path;
        IEditorInput input;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection) && (input = HandlerUtil.getActiveEditorInput((ExecutionEvent)event)) instanceof IPathEditorInput && (path = ((IPathEditorInput)input).getPath()) != null) {
            if (path.toFile().isFile()) {
                path = path.removeLastSegments(1);
            }
            if (path.toFile().isDirectory() && path.toFile().canRead()) {
                selection = new StructuredSelection((Object)path);
            }
        }
        return selection;
    }

    private void executeDelegate(ISelection selection, ILauncherDelegate delegate) throws ExecutionException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("delegateId", delegate.getId());
        properties.put("selection", (String)selection);
        try {
            delegate.execute(properties);
        }
        catch (Exception e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }
}

