/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.clangd.plugin;

import org.eclipse.cdt.lsp.clangd.format.ClangFormatFileMonitor;
import org.eclipse.cdt.lsp.clangd.internal.config.ClangFormatMonitor;
import org.eclipse.cdt.lsp.clangd.internal.config.ClangdCompilationDatabaseSetter;
import org.eclipse.cdt.lsp.clangd.internal.config.ClangdConfigFileMonitor;
import org.eclipse.cdt.lsp.clangd.internal.config.CompileCommandsMonitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class ClangdPlugin
extends AbstractUIPlugin {
    private ServiceTracker<IWorkspace, IWorkspace> workspaceTracker;
    private IWorkspace workspace;
    private CompileCommandsMonitor compileCommandsMonitor;
    private ClangdCompilationDatabaseSetter cProjectChangeMonitor;
    private ClangdConfigFileMonitor configFileMonitor;
    private ClangFormatFileMonitor clangFormatMonitor;
    private ClangFormatMonitor formatMonitor;
    public static final String PLUGIN_ID = "org.eclipse.cdt.lsp.clangd";
    private static ClangdPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.workspaceTracker = new ServiceTracker(context, IWorkspace.class, null);
        this.workspaceTracker.open();
        this.workspace = (IWorkspace)this.workspaceTracker.getService();
        this.compileCommandsMonitor = new CompileCommandsMonitor(this.workspace).start();
        this.cProjectChangeMonitor = new ClangdCompilationDatabaseSetter().start(this.workspace);
        this.configFileMonitor = new ClangdConfigFileMonitor(this.workspace).start();
        this.clangFormatMonitor = new ClangFormatFileMonitor(this.workspace).start();
        this.formatMonitor = new ClangFormatMonitor().start();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        this.compileCommandsMonitor.stop();
        this.cProjectChangeMonitor.stop(this.workspace);
        this.configFileMonitor.stop();
        this.clangFormatMonitor.stop();
        this.formatMonitor.stop();
        this.workspaceTracker.close();
        super.stop(context);
    }

    public static ClangdPlugin getDefault() {
        return plugin;
    }

    public IWorkspace getWorkspace() {
        return this.workspace;
    }
}

