/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.autotools.core.AutotoolsPlugin;
import org.eclipse.cdt.remote.core.RemoteCommandLauncher;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IMarkerResolution;

public class PkgconfigErrorResolution
implements IMarkerResolution {
    private static final String PKG_UPDATE_MSG = "UpdatePackage.msg";
    private String pkgName;

    public PkgconfigErrorResolution(String pkgconfigRequirement) {
        Pattern p = Pattern.compile("(.*?)[\\s,>,<,=].*");
        Matcher m = p.matcher(pkgconfigRequirement);
        if (m.matches()) {
            this.pkgName = m.group(1);
        }
    }

    public String getLabel() {
        return AutotoolsPlugin.getFormattedString(PKG_UPDATE_MSG, new String[]{this.pkgName});
    }

    public void run(IMarker marker) {
        block7: {
            IPath pkgconfigPath = new Path("/usr/lib/pkgconfig").append(this.pkgName + ".pc");
            RemoteCommandLauncher launcher = new RemoteCommandLauncher();
            Path commandPath = new Path("rpm");
            String[] commandArgs = new String[]{"-q", "--queryformat", "%{NAME}", "--whatprovides", pkgconfigPath.toOSString()};
            try {
                ConsoleOutputStream output = new ConsoleOutputStream();
                Process proc = launcher.execute((IPath)commandPath, commandArgs, null, (IPath)new Path("."), (IProgressMonitor)new NullProgressMonitor());
                if (proc == null) break block7;
                try {
                    proc.getOutputStream().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (launcher.waitAndRead((OutputStream)output, (OutputStream)output, (IProgressMonitor)new NullProgressMonitor()) != 0) {
                    AutotoolsPlugin.logErrorMessage(launcher.getErrorMessage());
                } else {
                    String result = output.readBuffer();
                    if (!result.startsWith("error:")) {
                        System.out.println("need to execute update of " + result);
                    }
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private static class ConsoleOutputStream
    extends OutputStream {
        protected StringBuffer fBuffer = new StringBuffer();

        public synchronized String readBuffer() {
            String buf = this.fBuffer.toString();
            this.fBuffer.setLength(0);
            return buf;
        }

        @Override
        public synchronized void write(int c) {
            byte[] ascii = new byte[]{(byte)c};
            this.fBuffer.append(new String(ascii));
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) {
            this.fBuffer.append(new String(b, off, len));
        }
    }
}

