/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.asciidoc.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.mylyn.wikitext.asciidoc.internal.util.LookAheadReader;
import org.eclipse.mylyn.wikitext.asciidoc.internal.util.ReadAheadBlock;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.parser.markup.Block;
import org.eclipse.mylyn.wikitext.parser.markup.ContentState;

public class ReadAheadDispatcher
extends Block {
    private final LookAheadReader lookAheadReader;
    private List<Block> blocks;
    private Block dispatchedBlock;

    public ReadAheadDispatcher(Block ... blocks) {
        this.blocks = this.cloneBlocks(Arrays.asList(blocks));
        this.lookAheadReader = new LookAheadReader();
    }

    public boolean canStart(String line, int lineOffset) {
        this.dispatchedBlock = null;
        return true;
    }

    protected int processLineContent(String line, int offset) {
        if (this.dispatchedBlock == null) {
            this.lookAheadReader.setContentState(this.getState());
            for (Block block : this.blocks) {
                if (block instanceof ReadAheadBlock) {
                    ReadAheadBlock raBlock = (ReadAheadBlock)ReadAheadBlock.class.cast(block);
                    if (!raBlock.canStart(line, offset, this.lookAheadReader)) continue;
                    this.dispatchedBlock = block;
                    break;
                }
                if (!block.canStart(line, offset)) continue;
                this.dispatchedBlock = block;
                break;
            }
        }
        int result = this.dispatchedBlock.processLine(line, offset);
        if (this.dispatchedBlock.isClosed()) {
            this.setClosed(true);
        }
        return result;
    }

    public void setClosed(boolean closed) {
        this.dispatchedBlock.setClosed(closed);
        super.setClosed(closed);
    }

    public void setState(ContentState state) {
        for (Block block : this.blocks) {
            block.setState(state);
        }
        super.setState(state);
    }

    public void setParser(MarkupParser parser) {
        for (Block block : this.blocks) {
            block.setParser(parser);
        }
        super.setParser(parser);
    }

    public Block clone() {
        ReadAheadDispatcher clone = (ReadAheadDispatcher)super.clone();
        clone.blocks = this.cloneBlocks(this.blocks);
        return clone;
    }

    private List<Block> cloneBlocks(List<Block> blocks) {
        ArrayList<Block> clonedBlocks = new ArrayList<Block>();
        for (Block block : blocks) {
            clonedBlocks.add(block.clone());
        }
        return clonedBlocks;
    }
}

