/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.workbench.DelayedRefreshJob;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextChangeEvent;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.ui.AbstractFocusViewAction;
import org.eclipse.mylyn.context.ui.InterestFilter;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.ui.BrowseFilteredListener;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.context.ui.FilteredChildrenDecorationDrawer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class FocusedViewerManager
extends AbstractContextListener
implements ISelectionListener {
    private final CopyOnWriteArrayList<StructuredViewer> managedViewers = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<StructuredViewer> filteredViewers = new CopyOnWriteArrayList();
    private final Map<StructuredViewer, AbstractFocusViewAction> focusActions = new HashMap<StructuredViewer, AbstractFocusViewAction>();
    private final Map<StructuredViewer, BrowseFilteredListener> listenerMap = new HashMap<StructuredViewer, BrowseFilteredListener>();
    private final Map<IWorkbenchPart, StructuredViewer> partToViewerMap = new HashMap<IWorkbenchPart, StructuredViewer>();
    private final Map<StructuredViewer, FocusedViewerDelayedRefreshJob> fullRefreshJobs = new HashMap<StructuredViewer, FocusedViewerDelayedRefreshJob>();
    private final Map<StructuredViewer, FocusedViewerDelayedRefreshJob> minorRefreshJobs = new HashMap<StructuredViewer, FocusedViewerDelayedRefreshJob>();
    private boolean syncRefreshMode = false;
    private final Map<TreeViewer, FilteredChildrenDecorationDrawer> decorationMap = new HashMap<TreeViewer, FilteredChildrenDecorationDrawer>();

    public void dispose() {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public void addManagedViewer(StructuredViewer viewer, IWorkbenchPart viewPart) {
        if (viewer != null && !this.managedViewers.contains(viewer)) {
            this.managedViewers.add(viewer);
            this.partToViewerMap.put(viewPart, viewer);
            BrowseFilteredListener listener = new BrowseFilteredListener(viewer);
            this.listenerMap.put(viewer, listener);
            viewer.getControl().addMouseListener((MouseListener)listener);
            viewer.getControl().addKeyListener((KeyListener)listener);
            try {
                FocusedViewerManager.initializeViewerSelection(viewPart);
                Set<IInteractionElement> emptySet = Collections.emptySet();
                this.refreshViewer(emptySet, true, viewer, true);
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Could not initialize focused viewer", (Throwable)e));
            }
        }
    }

    private void removeFilterDecorations(StructuredViewer viewer) {
        TreeViewer treeViewer;
        FilteredChildrenDecorationDrawer filterViewDrawer;
        if (viewer instanceof TreeViewer && (filterViewDrawer = this.decorationMap.remove(treeViewer = (TreeViewer)viewer)) != null) {
            filterViewDrawer.dispose();
        }
    }

    private void addFilterDecorations(StructuredViewer viewer, BrowseFilteredListener listener) {
        TreeViewer treeViewer;
        FilteredChildrenDecorationDrawer filteredViewDrawer;
        if (viewer instanceof TreeViewer && (filteredViewDrawer = new FilteredChildrenDecorationDrawer(treeViewer = (TreeViewer)viewer, listener)).applyToTreeViewer()) {
            this.decorationMap.put(treeViewer, filteredViewDrawer);
        }
    }

    public void removeManagedViewer(StructuredViewer viewer, IWorkbenchPart viewPart) {
        this.managedViewers.remove(viewer);
        this.partToViewerMap.remove(viewPart);
        this.removeFilterDecorations(viewer);
        BrowseFilteredListener listener = this.listenerMap.get(viewer);
        if (listener != null && viewer != null && !viewer.getControl().isDisposed()) {
            viewer.getControl().removeMouseListener((MouseListener)listener);
            viewer.getControl().removeKeyListener((KeyListener)listener);
        }
    }

    public void addFilteredViewer(StructuredViewer viewer, AbstractFocusViewAction action) {
        BrowseFilteredListener listener;
        this.addFilteredViewer(viewer);
        if (viewer != null && action != null) {
            this.focusActions.put(viewer, action);
        }
        if ((listener = this.listenerMap.get(viewer)) != null) {
            this.addFilterDecorations(viewer, listener);
        }
    }

    @Deprecated
    public void addFilteredViewer(StructuredViewer viewer) {
        if (viewer != null && !this.filteredViewers.contains(viewer)) {
            this.filteredViewers.add(viewer);
        }
    }

    public void removeFilteredViewer(StructuredViewer viewer) {
        this.removeFilterDecorations(viewer);
        this.focusActions.remove(viewer);
        this.filteredViewers.remove(viewer);
    }

    public void contextChanged(ContextChangeEvent event) {
        switch (event.getEventKind()) {
            case ACTIVATED: {
                this.refreshViewers();
                break;
            }
            case DEACTIVATED: {
                this.refreshViewers();
                for (StructuredViewer structuredViewer : this.managedViewers) {
                    if (!(structuredViewer instanceof TreeViewer)) continue;
                    ((TreeViewer)structuredViewer).collapseAll();
                }
                break;
            }
            case CLEARED: {
                if (!event.isActiveContext()) break;
                this.refreshViewers();
                for (StructuredViewer structuredViewer : this.managedViewers) {
                    if (!(structuredViewer instanceof TreeViewer)) continue;
                    ((TreeViewer)structuredViewer).collapseAll();
                }
                break;
            }
            case INTEREST_CHANGED: {
                if (!event.isActiveContext()) break;
                this.refreshViewers(event.getElements(), false, true);
                break;
            }
            case LANDMARKS_ADDED: {
                if (!event.isActiveContext()) break;
                this.refreshViewers(event.getElements(), true, false);
                break;
            }
            case LANDMARKS_REMOVED: {
                if (!event.isActiveContext()) break;
                this.refreshViewers(event.getElements(), true, false);
                break;
            }
            case ELEMENTS_DELETED: {
                if (!event.isActiveContext()) break;
                ArrayList<IInteractionElement> toRefresh = new ArrayList<IInteractionElement>();
                for (IInteractionElement interactionElement : event.getElements()) {
                    AbstractContextStructureBridge structureBridge = ContextCore.getStructureBridge((String)interactionElement.getContentType());
                    IInteractionElement parent = ContextCore.getContextManager().getElement(structureBridge.getParentHandle(interactionElement.getHandleIdentifier()));
                    if (parent == null) continue;
                    toRefresh.add(parent);
                }
                this.refreshViewers(toRefresh, false, false);
            }
        }
    }

    protected void refreshViewers() {
        List<IInteractionElement> toRefresh = Collections.emptyList();
        this.refreshViewers(toRefresh, true, true);
    }

    @Deprecated
    protected void refreshViewers(IInteractionElement node, boolean updateLabels) {
        this.refreshViewers(node, updateLabels, true);
    }

    protected void refreshViewers(IInteractionElement node, boolean updateLabels, boolean updateExpansion) {
        ArrayList<IInteractionElement> toRefresh = new ArrayList<IInteractionElement>();
        toRefresh.add(node);
        this.refreshViewers(toRefresh, updateLabels, updateExpansion);
    }

    @Deprecated
    protected void refreshViewers(List<IInteractionElement> nodesToRefresh, boolean updateLabels) {
        this.refreshViewers(nodesToRefresh, updateLabels, true);
    }

    protected void refreshViewers(List<IInteractionElement> nodesToRefresh, boolean updateLabels, boolean updateExpansion) {
        if (nodesToRefresh == null) {
            return;
        }
        if (this.syncRefreshMode) {
            this.internalRefresh(new HashSet<IInteractionElement>(nodesToRefresh), updateLabels, updateExpansion);
        } else {
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> this.internalRefresh(new HashSet<IInteractionElement>(nodesToRefresh), updateLabels, updateExpansion));
        }
    }

    private void internalRefresh(Set<IInteractionElement> nodesToRefresh, boolean updateLabels, boolean updateExpansion) {
        try {
            for (StructuredViewer viewer : this.managedViewers) {
                this.refreshViewer(nodesToRefresh, updateLabels, viewer, updateExpansion);
            }
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Could not refresh viewer", t));
        }
    }

    @Deprecated
    public void refreshViewer(Set<IInteractionElement> nodesToRefresh, boolean updateLabels, StructuredViewer viewer) {
        this.refreshViewer(nodesToRefresh, updateLabels, viewer, true);
    }

    public void refreshViewer(Set<IInteractionElement> nodesToRefresh, boolean updateLabels, StructuredViewer viewer, boolean updateExpansion) {
        Map<StructuredViewer, FocusedViewerDelayedRefreshJob> refreshJobs = null;
        refreshJobs = updateLabels ? this.minorRefreshJobs : this.fullRefreshJobs;
        FocusedViewerDelayedRefreshJob job = refreshJobs.get(viewer);
        if (job == null) {
            job = new FocusedViewerDelayedRefreshJob(viewer, "refresh viewer", updateLabels);
            refreshJobs.put(viewer, job);
        }
        job.refreshElements(nodesToRefresh.toArray(), updateExpansion);
    }

    private void updateExpansionState(StructuredViewer viewer, Object objectToRefresh) {
        if (viewer instanceof TreeViewer) {
            TreeViewer treeViewer = (TreeViewer)viewer;
            if (this.filteredViewers.contains(viewer) && this.hasInterestFilter(viewer, true) && ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.ide.ui.expansion.auto.manage")) {
                if ("org.eclipse.ui.internal.views.markers.MarkersTreeViewer".equals(treeViewer.getClass().getCanonicalName())) {
                    objectToRefresh = null;
                }
                if (objectToRefresh == null) {
                    treeViewer.expandAll();
                } else {
                    treeViewer.expandToLevel(objectToRefresh, -1);
                }
            }
        }
    }

    private boolean hasInterestFilter(StructuredViewer viewer, boolean tryToReinstall) {
        AbstractFocusViewAction action;
        ViewerFilter[] viewerFilterArray = viewer.getFilters();
        int n = viewerFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter filter = viewerFilterArray[n2];
            if (filter instanceof InterestFilter) {
                return true;
            }
            ++n2;
        }
        if (tryToReinstall && (action = this.focusActions.get(viewer)) != null) {
            action.run((IAction)action);
            viewer.refresh();
            return this.hasInterestFilter(viewer, false);
        }
        return false;
    }

    public void setSyncRefreshMode(boolean syncRefreshMode) {
        this.syncRefreshMode = syncRefreshMode;
    }

    public void forceRefresh() {
        this.refreshViewers();
    }

    public static void initializeViewerSelection(IWorkbenchPart part) {
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider != null) {
            ISelection selection = selectionProvider.getSelection();
            try {
                if (selection != null) {
                    selectionProvider.setSelection(selection);
                } else {
                    selectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    private class FocusedViewerDelayedRefreshJob
    extends DelayedRefreshJob {
        private boolean minor;
        private boolean updateExpansion;

        public FocusedViewerDelayedRefreshJob(StructuredViewer viewer, String name, boolean minor) {
            super(viewer, name);
            this.minor = false;
            this.minor = minor;
        }

        protected void doRefresh(Object[] items) {
            block25: {
                try {
                    if (this.viewer == null) {
                        return;
                    }
                    if (this.viewer.getControl().isDisposed()) {
                        FocusedViewerManager.this.managedViewers.remove(this.viewer);
                        break block25;
                    }
                    if (items == null || items.length == 0) {
                        if (!this.minor) {
                            this.viewer.refresh(false);
                            if (this.updateExpansion) {
                                FocusedViewerManager.this.updateExpansionState(this.viewer, null);
                            }
                            break block25;
                        }
                        try {
                            this.viewer.getControl().setRedraw(false);
                            this.viewer.refresh(true);
                            if (this.updateExpansion) {
                                FocusedViewerManager.this.updateExpansionState(this.viewer, null);
                            }
                            break block25;
                        }
                        finally {
                            this.viewer.getControl().setRedraw(true);
                        }
                    }
                    if (FocusedViewerManager.this.filteredViewers.contains(this.viewer)) {
                        try {
                            this.viewer.getControl().setRedraw(false);
                            this.viewer.refresh(this.minor);
                            if (this.updateExpansion) {
                                FocusedViewerManager.this.updateExpansionState(this.viewer, null);
                            }
                            break block25;
                        }
                        finally {
                            this.viewer.getControl().setRedraw(true);
                        }
                    }
                    try {
                        this.viewer.getControl().setRedraw(false);
                        Object[] objectArray = items;
                        int n = items.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object item;
                            Object objectToRefresh = item = objectArray[n2];
                            if (item instanceof IInteractionElement) {
                                IInteractionElement node = (IInteractionElement)item;
                                AbstractContextStructureBridge structureBridge = ContextCorePlugin.getDefault().getStructureBridge(node.getContentType());
                                objectToRefresh = structureBridge.getObjectForHandle(node.getHandleIdentifier());
                            }
                            if (objectToRefresh != null) {
                                this.viewer.update(objectToRefresh, null);
                                if (this.updateExpansion) {
                                    FocusedViewerManager.this.updateExpansionState(this.viewer, objectToRefresh);
                                }
                            }
                            ++n2;
                        }
                    }
                    finally {
                        this.viewer.getControl().setRedraw(true);
                    }
                }
                finally {
                    this.updateExpansion = false;
                }
            }
        }

        public void refreshElements(Object[] elements, boolean updateExpansion) {
            this.updateExpansion |= updateExpansion;
            super.refreshElements(elements);
        }

        public void refreshElements(Object[] elements) {
            this.refreshElements(elements, true);
        }
    }
}

