/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.navigator;

import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.OpenFileAction;

public class OpenCElementAction
extends OpenFileAction {
    private ICElement fOpenElement;

    public OpenCElementAction(IWorkbenchPage page) {
        super(page);
    }

    public void run() {
        if (this.fOpenElement != null) {
            try {
                IEditorPart part = EditorUtility.openInEditor(this.fOpenElement);
                if (this.fOpenElement instanceof ISourceReference && !(this.fOpenElement instanceof ITranslationUnit)) {
                    EditorUtility.revealInEditor(part, this.fOpenElement);
                }
            }
            catch (CoreException exc) {
                CUIPlugin.log(exc.getStatus());
            }
        } else {
            super.run();
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.fOpenElement = null;
        if (selection.size() == 1) {
            ICElement cElement;
            Object element = selection.getFirstElement();
            if (!(element instanceof ICElement) && element instanceof IAdaptable) {
                element = ((IAdaptable)element).getAdapter(ICElement.class);
            }
            if (element instanceof ICElement && this.canOpenCElement(cElement = (ICElement)element)) {
                this.fOpenElement = (ICElement)element;
            }
        }
        return this.fOpenElement != null || super.updateSelection(selection);
    }

    private boolean canOpenCElement(ICElement element) {
        if (element instanceof ISourceReference) {
            ITranslationUnit tu;
            ISourceReference sourceReference = (ISourceReference)element;
            if (sourceReference.getTranslationUnit() == null) {
                return false;
            }
            return !(element instanceof ITranslationUnit) || (tu = (ITranslationUnit)element).getResource() != null || tu.exists();
        }
        if (element instanceof IBinary) {
            IResource resource = element.getResource();
            return resource != null && resource.exists();
        }
        return false;
    }
}

