/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.ui.action;

import java.util.List;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public abstract class ViewerFilterAction
extends Action {
    protected List<Viewer> viewers;
    protected ViewerFilter viewerFilter;

    public ViewerFilterAction(String text, int style) {
        super(text, style);
        this.setId(Integer.toString(((Object)((Object)this)).hashCode()));
    }

    public void addViewer(Viewer viewer) {
        if (viewer instanceof StructuredViewer) {
            if (this.viewers == null) {
                this.viewers = new UniqueEList.FastCompare();
            }
            if (this.viewers.add(viewer)) {
                if (this.viewerFilter == null) {
                    this.viewerFilter = new ViewerFilter(){

                        public boolean select(Viewer viewer, Object parentElement, Object element) {
                            return ViewerFilterAction.this.select(viewer, parentElement, element);
                        }
                    };
                }
                ((StructuredViewer)viewer).addFilter(this.viewerFilter);
            }
        }
    }

    public void removeViewer(Viewer viewer) {
        if (this.viewers != null && this.viewers.remove(viewer) && !viewer.getControl().isDisposed()) {
            ((StructuredViewer)viewer).removeFilter(this.viewerFilter);
        }
    }

    public void dispose() {
        if (this.viewers != null) {
            for (Viewer viewer : this.viewers) {
                if (viewer.getControl().isDisposed()) continue;
                ((StructuredViewer)viewer).removeFilter(this.viewerFilter);
            }
            this.viewers.clear();
            this.viewers = null;
        }
        this.viewerFilter = null;
    }

    public void setChecked(boolean checked) {
        boolean wasChecked = this.isChecked();
        super.setChecked(checked);
        if (wasChecked != checked) {
            this.refreshViewers();
        }
    }

    protected void refreshViewers() {
        if (this.viewers != null) {
            for (Viewer viewer : this.viewers) {
                if (viewer.getControl().isDisposed()) continue;
                viewer.refresh();
            }
        }
    }

    public abstract boolean select(Viewer var1, Object var2, Object var3);
}

