/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.wizards;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import org.eclipse.eclemma.core.ScopeUtils;
import org.eclipse.eclemma.internal.ui.ContextHelp;
import org.eclipse.eclemma.internal.ui.EclEmmaUIPlugin;
import org.eclipse.eclemma.internal.ui.ScopeViewer;
import org.eclipse.eclemma.internal.ui.UIMessages;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionImportPage2
extends WizardPage {
    private static final String ID = "SessionImportPage2";
    private static final String STORE_PREFIX = "SessionImportPage2.";
    private static final String STORE_SCOPE = "SessionImportPage2.scope";
    private static final String STORE_BINARIES = "SessionImportPage2.binaries";
    private Text descriptiontext;
    private ScopeViewer scopeviewer;
    private Button binariescheck;

    protected SessionImportPage2() {
        super(ID);
        this.setTitle(UIMessages.ImportSessionPage1_title);
        this.setDescription(UIMessages.ImportSessionPage1_description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        parent = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        this.createNameBlock(parent);
        this.createScopeBlock(parent);
        this.createButtonsBlock(parent);
        this.setControl((Control)parent);
        ContextHelp.setHelp((Control)parent, "org.eclipse.eclemma.ui.session_import_context");
        this.restoreWidgetValues();
        this.update();
    }

    private void createNameBlock(Composite parent) {
        parent = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(768));
        new Label(parent, 0).setText(UIMessages.ImportSessionPage1Description_label);
        this.descriptiontext = new Text(parent, 2048);
        this.descriptiontext.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SessionImportPage2.this.update();
            }
        });
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.descriptiontext.setLayoutData((Object)gd);
    }

    private void createScopeBlock(Composite parent) {
        this.scopeviewer = new ScopeViewer(parent, 2048);
        try {
            this.scopeviewer.setInput(ScopeUtils.getWorkspaceScope());
        }
        catch (JavaModelException e) {
            EclEmmaUIPlugin.log(e);
        }
        this.scopeviewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SessionImportPage2.this.update();
            }
        });
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(120);
        gd.heightHint = this.convertHeightInCharsToPixels(8);
        this.scopeviewer.getTable().setLayoutData((Object)gd);
    }

    private void createButtonsBlock(Composite parent) {
        parent = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(768));
        this.binariescheck = new Button(parent, 32);
        this.binariescheck.setText(UIMessages.ImportSessionPage1Binaries_label);
        this.binariescheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SessionImportPage2.this.scopeviewer.setIncludeBinaries(SessionImportPage2.this.binariescheck.getSelection());
                SessionImportPage2.this.update();
            }
        });
        this.binariescheck.setLayoutData((Object)new GridData(512));
        Button buttonSelectAll = new Button(parent, 8);
        buttonSelectAll.setText(UIMessages.SelectAllAction_label);
        buttonSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SessionImportPage2.this.scopeviewer.selectAll();
                SessionImportPage2.this.update();
            }
        });
        this.setButtonLayoutData(buttonSelectAll);
        Button buttonDeselectAll = new Button(parent, 8);
        buttonDeselectAll.setText(UIMessages.DeselectAllAction_label);
        buttonDeselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SessionImportPage2.this.scopeviewer.deselectAll();
                SessionImportPage2.this.update();
            }
        });
        this.setButtonLayoutData(buttonDeselectAll);
    }

    private void update() {
        if (this.getSessionDescription().length() == 0) {
            this.setErrorMessage(UIMessages.ImportSessionPage1NoDescription_message);
            this.setPageComplete(false);
            return;
        }
        if (this.getScope().isEmpty()) {
            this.setErrorMessage(UIMessages.ImportSessionPage1NoClassFiles_message);
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private void restoreWidgetValues() {
        String descr = UIMessages.ImportSessionPage1Description_value;
        Object[] arg = new Object[]{new Date()};
        this.descriptiontext.setText(MessageFormat.format(descr, arg));
        IDialogSettings settings = this.getDialogSettings();
        boolean binaries = settings.getBoolean(STORE_BINARIES);
        this.scopeviewer.setIncludeBinaries(binaries);
        this.binariescheck.setSelection(binaries);
        String[] classes = settings.getArray(STORE_SCOPE);
        if (classes != null) {
            this.scopeviewer.setSelectedScope(ScopeUtils.readScope(Arrays.asList(classes)));
        }
    }

    public void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(STORE_SCOPE, ScopeUtils.writeScope(this.scopeviewer.getSelectedScope()).toArray(new String[0]));
        settings.put(STORE_BINARIES, this.binariescheck.getSelection());
    }

    public String getSessionDescription() {
        return this.descriptiontext.getText().trim();
    }

    public Set<IPackageFragmentRoot> getScope() {
        return this.scopeviewer.getSelectedScope();
    }
}

