/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualFile;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public class ResourceListVirtualFolder
extends VirtualFolder {
    private ArrayList<IResource> children = new ArrayList();
    private ArrayList<IContainer> underlying = new ArrayList();
    private ResourceFilter filter;

    public ResourceListVirtualFolder(IProject aComponentProject, IPath aRuntimePath) {
        super(aComponentProject, aRuntimePath);
    }

    public ResourceListVirtualFolder(IProject aComponentProject, IPath aRuntimePath, IContainer[] underlyingContainers) {
        this(aComponentProject, aRuntimePath);
        this.addUnderlyingResource((IResource[])underlyingContainers);
    }

    public ResourceListVirtualFolder(IProject aComponentProject, IPath aRuntimePath, IContainer[] underlyingContainers, IResource[] looseResources) {
        this(aComponentProject, aRuntimePath, underlyingContainers);
        this.addChildren(looseResources);
    }

    public void setFilter(ResourceFilter filter) {
        this.filter = filter;
    }

    protected void addUnderlyingResource(IResource resource) {
        if (resource instanceof IContainer) {
            this.underlying.add((IContainer)resource);
            try {
                IResource[] newChildren = ((IContainer)resource).members();
                int i = 0;
                while (i < newChildren.length) {
                    this.children.add(newChildren[i]);
                    ++i;
                }
            }
            catch (CoreException coreException) {}
        }
    }

    protected void addUnderlyingResource(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            this.addUnderlyingResource(resources[i]);
            ++i;
        }
    }

    protected void addChild(IResource resource) {
        this.children.add(resource);
    }

    protected void addChildren(IResource[] resources) {
        this.children.addAll(Arrays.asList(resources));
    }

    @Override
    public IResource getUnderlyingResource() {
        return this.getUnderlyingFolder();
    }

    @Override
    public IResource[] getUnderlyingResources() {
        return this.getUnderlyingFolders();
    }

    @Override
    public IContainer getUnderlyingFolder() {
        return this.underlying.size() > 0 ? this.underlying.get(0) : null;
    }

    @Override
    public IContainer[] getUnderlyingFolders() {
        return this.underlying.toArray(new IContainer[this.underlying.size()]);
    }

    @Override
    public IVirtualResource[] members(int memberFlags) throws CoreException {
        HashMap<String, IVirtualResource> virtualResources = new HashMap<String, IVirtualResource>();
        IResource[] resources = this.children.toArray(new IResource[this.children.size()]);
        int i = 0;
        while (i < resources.length) {
            this.handleResource(resources[i], virtualResources, memberFlags);
            ++i;
        }
        Collection c = virtualResources.values();
        return c.toArray(new IVirtualResource[c.size()]);
    }

    protected void handleResource(IResource resource, HashMap<String, IVirtualResource> map, int memberFlags) throws CoreException {
        if (this.filter != null && !this.filter.accepts(resource)) {
            return;
        }
        if (resource instanceof IFile) {
            if (!map.containsKey(resource.getName())) {
                VirtualFile virtFile = new VirtualFile(this.getProject(), this.getRuntimePath().append(((IFile)resource).getName()), (IFile)resource);
                map.put(resource.getName(), virtFile);
                return;
            }
        } else if (resource instanceof IContainer) {
            IContainer realContainer = (IContainer)resource;
            IVirtualResource previousValue = map.get(resource.getName());
            if (previousValue != null && previousValue instanceof ResourceListVirtualFolder) {
                ((ResourceListVirtualFolder)previousValue).addUnderlyingResource((IResource)realContainer);
            } else if (previousValue == null) {
                ResourceListVirtualFolder childFolder = new ResourceListVirtualFolder(this.getProject(), this.getRuntimePath().append(resource.getName()));
                childFolder.addUnderlyingResource((IResource)realContainer);
                if (this.filter != null) {
                    childFolder.setFilter(this.filter);
                }
                map.put(resource.getName(), childFolder);
            }
        }
    }

    public static interface ResourceFilter {
        public boolean accepts(IResource var1);
    }
}

