/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.context.symbol.internal.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EDataTypeEList;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.common.util.TypeUtil;
import org.eclipse.jst.jsf.context.symbol.IObjectSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.ITypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.SymbolPackage;

public abstract class ITypeDescriptorImpl
extends EObjectImpl
implements ITypeDescriptor {
    public static final String copyright = "Copyright 2006 Oracle";
    protected static final String TYPE_SIGNATURE_EDEFAULT = "";
    protected static final String TYPE_SIGNATURE_DELEGATE_EDEFAULT = null;
    protected String typeSignatureDelegate = TYPE_SIGNATURE_DELEGATE_EDEFAULT;
    protected EList typeParameterSignatures;
    protected static final IJavaElement JDT_CONTEXT_EDEFAULT = null;
    protected IJavaElement jdtContext = JDT_CONTEXT_EDEFAULT;
    protected static final boolean ENUM_TYPE_EDEFAULT = false;
    protected boolean enumType = false;

    protected ITypeDescriptorImpl() {
    }

    protected EClass eStaticClass() {
        return SymbolPackage.Literals.ITYPE_DESCRIPTOR;
    }

    @Override
    public abstract EList getProperties();

    @Override
    public abstract String getTypeSignature();

    @Override
    public abstract EList getSuperTypeSignatures();

    @Override
    public abstract EList getInterfaceTypeSignatures();

    @Override
    public String getTypeSignatureDelegate() {
        return this.typeSignatureDelegate;
    }

    @Override
    public void setTypeSignatureDelegate(String newTypeSignatureDelegate) {
        String oldTypeSignatureDelegate = this.typeSignatureDelegate;
        this.typeSignatureDelegate = newTypeSignatureDelegate;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldTypeSignatureDelegate, (Object)this.typeSignatureDelegate));
        }
    }

    @Override
    public abstract EList getMethods();

    @Override
    public EList getTypeParameterSignatures() {
        if (this.typeParameterSignatures == null) {
            this.typeParameterSignatures = new EDataTypeEList(String.class, (InternalEObject)this, 6);
        }
        return this.typeParameterSignatures;
    }

    @Override
    public IJavaElement getJdtContext() {
        return this.jdtContext;
    }

    @Override
    public void setJdtContext(IJavaElement newJdtContext) {
        IJavaElement oldJdtContext = this.jdtContext;
        this.jdtContext = newJdtContext;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldJdtContext, (Object)this.jdtContext));
        }
    }

    @Override
    public boolean isEnumType() {
        return this.enumType;
    }

    @Override
    public void setEnumType(boolean newEnumType) {
        boolean oldEnumType = this.enumType;
        this.enumType = newEnumType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, oldEnumType, this.enumType));
        }
    }

    @Override
    public boolean instanceOf(String typeSignature) {
        String typeErasedSignature = Signature.getTypeErasure((String)typeSignature);
        if (Signature.getTypeErasure((String)this.getTypeSignature()) != null && Signature.getTypeErasure((String)this.getTypeSignature()).equals(typeErasedSignature)) {
            return true;
        }
        for (String superType : this.getSuperTypeSignatures()) {
            if (!Signature.getTypeErasure((String)superType).equals(typeErasedSignature)) continue;
            return true;
        }
        for (String superType : this.getInterfaceTypeSignatures()) {
            if (!Signature.getTypeErasure((String)superType).equals(typeErasedSignature)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isArray() {
        return Signature.getArrayCount((String)this.getTypeSignature()) > 0;
    }

    @Override
    public IObjectSymbol getArrayElement() {
        if (this.isArray()) {
            throw new UnsupportedOperationException("Base type descriptor does not support this function");
        }
        return null;
    }

    @Override
    public IType resolveType(String resolvedTypeSignature) {
        IJavaProject project = null;
        if (this.getJdtContext() != null) {
            project = this.getJdtContext().getJavaProject();
        }
        if (project != null) {
            return TypeUtil.resolveType(project, resolvedTypeSignature);
        }
        return null;
    }

    @Override
    public ISymbol calculateSyntheticCall(String methodName, EList methodArgs, String symbolName) {
        return null;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getProperties();
            }
            case 1: {
                return this.getTypeSignature();
            }
            case 2: {
                return this.getSuperTypeSignatures();
            }
            case 3: {
                return this.getInterfaceTypeSignatures();
            }
            case 4: {
                return this.getTypeSignatureDelegate();
            }
            case 5: {
                return this.getMethods();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getProperties().clear();
                this.getProperties().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getSuperTypeSignatures().clear();
                this.getSuperTypeSignatures().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getInterfaceTypeSignatures().clear();
                this.getInterfaceTypeSignatures().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setTypeSignatureDelegate((String)newValue);
                return;
            }
            case 5: {
                this.getMethods().clear();
                this.getMethods().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getProperties().clear();
                return;
            }
            case 2: {
                this.getSuperTypeSignatures().clear();
                return;
            }
            case 3: {
                this.getInterfaceTypeSignatures().clear();
                return;
            }
            case 4: {
                this.setTypeSignatureDelegate(TYPE_SIGNATURE_DELEGATE_EDEFAULT);
                return;
            }
            case 5: {
                this.getMethods().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return !this.getProperties().isEmpty();
            }
            case 1: {
                return TYPE_SIGNATURE_EDEFAULT == null ? this.getTypeSignature() != null : !TYPE_SIGNATURE_EDEFAULT.equals(this.getTypeSignature());
            }
            case 2: {
                return !this.getSuperTypeSignatures().isEmpty();
            }
            case 3: {
                return !this.getInterfaceTypeSignatures().isEmpty();
            }
            case 4: {
                return TYPE_SIGNATURE_DELEGATE_EDEFAULT == null ? this.typeSignatureDelegate != null : !TYPE_SIGNATURE_DELEGATE_EDEFAULT.equals(this.typeSignatureDelegate);
            }
            case 5: {
                return !this.getMethods().isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (typeSignatureDelegate: ");
        result.append(this.typeSignatureDelegate);
        result.append(')');
        return result.toString();
    }
}

