/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.wst.jsdt.internal.ui.text.java.IJavaReconcilingListener;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.JavaScriptUI;

class OverrideIndicatorManager
implements IJavaReconcilingListener {
    static final String ANNOTATION_TYPE = "org.eclipse.wst.jsdt.ui.overrideIndicator";
    private IAnnotationModel fAnnotationModel;
    private Object fAnnotationModelLockObject;
    private Annotation[] fOverrideAnnotations;
    private IJavaScriptElement fJavaElement;

    public OverrideIndicatorManager(IAnnotationModel annotationModel, IJavaScriptElement javaElement, JavaScriptUnit ast) {
        Assert.isNotNull((Object)annotationModel);
        Assert.isNotNull((Object)javaElement);
        this.fJavaElement = javaElement;
        this.fAnnotationModel = annotationModel;
        this.fAnnotationModelLockObject = this.getLockObject(this.fAnnotationModel);
        this.updateAnnotations(ast, (IProgressMonitor)new NullProgressMonitor());
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAnnotations(JavaScriptUnit ast, IProgressMonitor progressMonitor) {
        if (ast == null || progressMonitor.isCanceled()) {
            return;
        }
        final HashMap annotationMap = new HashMap(50);
        ast.accept(new ASTVisitor(false){

            public boolean visit(FunctionDeclaration node) {
                IFunctionBinding definingMethod;
                IFunctionBinding binding = node.resolveBinding();
                if (binding != null && (definingMethod = Bindings.findOverriddenMethod(binding, true)) != null) {
                    ITypeBinding definingType = definingMethod.getDeclaringClass();
                    String qualifiedMethodName = String.valueOf(definingType.getQualifiedName()) + "." + binding.getName();
                    boolean isImplements = JdtFlags.isAbstract(definingMethod);
                    String text = isImplements ? Messages.format(JavaEditorMessages.OverrideIndicatorManager_implements, qualifiedMethodName) : Messages.format(JavaEditorMessages.OverrideIndicatorManager_overrides, qualifiedMethodName);
                    SimpleName name = node.getName();
                    Position position = name != null ? new Position(name.getStartPosition(), name.getLength()) : new Position(node.getStartPosition());
                    annotationMap.put(new OverrideIndicator(isImplements, text, binding.getKey()), position);
                }
                return true;
            }
        });
        if (progressMonitor.isCanceled()) {
            return;
        }
        Object object = this.fAnnotationModelLockObject;
        synchronized (object) {
            if (this.fAnnotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)this.fAnnotationModel).replaceAnnotations(this.fOverrideAnnotations, annotationMap);
            } else {
                this.removeAnnotations();
                for (Map.Entry mapEntry : annotationMap.entrySet()) {
                    this.fAnnotationModel.addAnnotation((Annotation)mapEntry.getKey(), (Position)mapEntry.getValue());
                }
            }
            this.fOverrideAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAnnotations() {
        if (this.fOverrideAnnotations == null) {
            return;
        }
        Object object = this.fAnnotationModelLockObject;
        synchronized (object) {
            if (this.fAnnotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)this.fAnnotationModel).replaceAnnotations(this.fOverrideAnnotations, null);
            } else {
                int i = 0;
                int length = this.fOverrideAnnotations.length;
                while (i < length) {
                    this.fAnnotationModel.removeAnnotation(this.fOverrideAnnotations[i]);
                    ++i;
                }
            }
            this.fOverrideAnnotations = null;
        }
    }

    @Override
    public void aboutToBeReconciled() {
    }

    @Override
    public void reconciled(JavaScriptUnit ast, boolean forced, IProgressMonitor progressMonitor) {
        this.updateAnnotations(ast, progressMonitor);
    }

    class OverrideIndicator
    extends Annotation {
        private boolean fIsOverwriteIndicator;
        private String fAstNodeKey;

        OverrideIndicator(boolean isOverwriteIndicator, String text, String key) {
            super(OverrideIndicatorManager.ANNOTATION_TYPE, false, text);
            this.fIsOverwriteIndicator = isOverwriteIndicator;
            this.fAstNodeKey = key;
        }

        public boolean isOverwriteIndicator() {
            return this.fIsOverwriteIndicator;
        }

        public void open() {
            ASTNode node;
            JavaScriptUnit ast = ASTProvider.getASTProvider().getAST(OverrideIndicatorManager.this.fJavaElement, ASTProvider.WAIT_ACTIVE_ONLY, null);
            if (ast != null && (node = ast.findDeclaringNode(this.fAstNodeKey)) instanceof FunctionDeclaration) {
                try {
                    IJavaScriptElement definingMethod;
                    IFunctionBinding methodBinding = ((FunctionDeclaration)node).resolveBinding();
                    IFunctionBinding definingMethodBinding = Bindings.findOverriddenMethod(methodBinding, true);
                    if (definingMethodBinding != null && (definingMethod = definingMethodBinding.getJavaElement()) != null) {
                        JavaScriptUI.openInEditor(definingMethod, true, true);
                        return;
                    }
                }
                catch (CoreException e) {
                    ExceptionHandler.handle(e, JavaEditorMessages.OverrideIndicatorManager_open_error_title, JavaEditorMessages.OverrideIndicatorManager_open_error_messageHasLogEntry);
                    return;
                }
            }
            String title = JavaEditorMessages.OverrideIndicatorManager_open_error_title;
            String message = JavaEditorMessages.OverrideIndicatorManager_open_error_message;
            MessageDialog.openError((Shell)JavaScriptPlugin.getActiveWorkbenchShell(), (String)title, (String)message);
        }
    }
}

