/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.bundleexclude;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;

public final class ResourcePropertyTester
extends PropertyTester {
    private static final String ANY_REFERENCING_PROJECT_HAS_FACET_PROPERTY = "anyReferencingProjectHasFacet";

    public boolean test(Object receiver, String property, Object[] args, Object value) {
        if (receiver instanceof IResource) {
            return this.test((IResource)receiver, property, value);
        }
        return false;
    }

    private boolean test(IResource resource, String property, Object value) {
        if (property.equals(ANY_REFERENCING_PROJECT_HAS_FACET_PROPERTY)) {
            return this.anyReferencingProjectHasFacet(resource.getProject(), (String)value);
        }
        return false;
    }

    private boolean anyReferencingProjectHasFacet(IProject project, String facetVersionExpression) {
        String versionExpression;
        String facetID;
        int colon = facetVersionExpression.indexOf(58);
        if (colon == -1 || colon == facetVersionExpression.length() - 1) {
            facetID = facetVersionExpression;
            versionExpression = null;
        } else {
            facetID = facetVersionExpression.substring(0, colon);
            versionExpression = facetVersionExpression.substring(colon + 1);
        }
        try {
            return this.anyReferencingProjectHasFacet(project, facetID, versionExpression);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean anyReferencingProjectHasFacet(IProject project, String facetID, String versionExpression) throws CoreException {
        if (FacetedProjectFramework.hasProjectFacet((IProject)project, (String)facetID, (String)versionExpression)) {
            return true;
        }
        IProject[] iProjectArray = project.getReferencingProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject refProject = iProjectArray[n2];
            if (FacetedProjectFramework.hasProjectFacet((IProject)refProject, (String)facetID, (String)versionExpression)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

