/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.embedded;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchHandler;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISessionManager;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.internal.embedded.ServerSession;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public final class ServerBranchLoader
implements InternalCDOBranchManager.BranchLoader5 {
    private final InternalCDOBranchManager.BranchLoader5 delegate;
    private final ISessionManager sessionManager;

    public ServerBranchLoader(InternalCDOBranchManager.BranchLoader5 delegate) {
        this.delegate = delegate;
        this.sessionManager = ((IRepository)delegate).getSessionManager();
    }

    public InternalCDOBranchManager.BranchLoader5 getDelegate() {
        return this.delegate;
    }

    public Pair<Integer, Long> createBranch(int branchID, InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo) {
        if (!StoreThreadLocal.hasSession()) {
            try {
                StoreThreadLocal.setSession((InternalSession)this.getServerSession());
                Pair pair = this.delegate.createBranch(branchID, branchInfo);
                return pair;
            }
            finally {
                StoreThreadLocal.release();
            }
        }
        return this.delegate.createBranch(branchID, branchInfo);
    }

    public InternalCDOBranchManager.BranchLoader.BranchInfo loadBranch(int branchID) {
        if (!StoreThreadLocal.hasSession()) {
            try {
                StoreThreadLocal.setSession((InternalSession)this.getServerSession());
                InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo = this.delegate.loadBranch(branchID);
                return branchInfo;
            }
            finally {
                StoreThreadLocal.release();
            }
        }
        return this.delegate.loadBranch(branchID);
    }

    public InternalCDOBranchManager.BranchLoader.SubBranchInfo[] loadSubBranches(int branchID) {
        if (!StoreThreadLocal.hasSession()) {
            try {
                StoreThreadLocal.setSession((InternalSession)this.getServerSession());
                InternalCDOBranchManager.BranchLoader.SubBranchInfo[] subBranchInfoArray = this.delegate.loadSubBranches(branchID);
                return subBranchInfoArray;
            }
            finally {
                StoreThreadLocal.release();
            }
        }
        return this.delegate.loadSubBranches(branchID);
    }

    public int loadBranches(int startID, int endID, CDOBranchHandler branchHandler) {
        if (!StoreThreadLocal.hasSession()) {
            try {
                StoreThreadLocal.setSession((InternalSession)this.getServerSession());
                int n = this.delegate.loadBranches(startID, endID, branchHandler);
                return n;
            }
            finally {
                StoreThreadLocal.release();
            }
        }
        return this.delegate.loadBranches(startID, endID, branchHandler);
    }

    public void renameBranch(int branchID, String oldName, String newName) {
        if (!StoreThreadLocal.hasSession()) {
            try {
                StoreThreadLocal.setSession((InternalSession)this.getServerSession());
                this.delegate.renameBranch(branchID, oldName, newName);
            }
            finally {
                StoreThreadLocal.release();
            }
        } else {
            this.delegate.renameBranch(branchID, oldName, newName);
        }
    }

    public CDOBranchPoint changeTag(AtomicInteger modCount, String oldName, String newName, CDOBranchPoint branchPoint) {
        if (!StoreThreadLocal.hasSession()) {
            try {
                StoreThreadLocal.setSession((InternalSession)this.getServerSession());
                CDOBranchPoint cDOBranchPoint = this.delegate.changeTag(modCount, oldName, newName, branchPoint);
                return cDOBranchPoint;
            }
            finally {
                StoreThreadLocal.release();
            }
        }
        return this.delegate.changeTag(modCount, oldName, newName, branchPoint);
    }

    public void loadTags(String name, Consumer<InternalCDOBranchManager.BranchLoader.BranchInfo> handler) {
        if (!StoreThreadLocal.hasSession()) {
            try {
                StoreThreadLocal.setSession((InternalSession)this.getServerSession());
                this.delegate.loadTags(name, handler);
            }
            finally {
                StoreThreadLocal.release();
            }
        } else {
            this.delegate.loadTags(name, handler);
        }
    }

    public CDOBranch[] deleteBranches(int branchID, OMMonitor monitor) {
        if (!StoreThreadLocal.hasSession()) {
            try {
                StoreThreadLocal.setSession((InternalSession)this.getServerSession());
                CDOBranch[] cDOBranchArray = this.delegate.deleteBranches(branchID, monitor);
                return cDOBranchArray;
            }
            finally {
                StoreThreadLocal.release();
            }
        }
        return this.delegate.deleteBranches(branchID, monitor);
    }

    @Deprecated
    public void deleteBranch(int branchID) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void renameBranch(int branchID, String newName) {
        throw new UnsupportedOperationException();
    }

    private InternalSession getServerSession() {
        InternalSession serverSession = ServerSession.get();
        if (serverSession == null) {
            serverSession = (InternalSession)this.sessionManager.getSessions()[0];
        }
        return serverSession;
    }
}

