/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.common.util.URIHandlerRegistry;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.IFactoryKey;

public final class URIHandlerRegistryImpl
implements URIHandlerRegistry,
URIHandler {
    public static final URIHandlerRegistryImpl INSTANCE = new URIHandlerRegistryImpl();
    private final Map<String, URIHandler> handlers = new HashMap<String, URIHandler>();
    private boolean initialized;

    private URIHandlerRegistryImpl() {
    }

    private void initialize() {
        if (!this.initialized) {
            this.initialized = true;
            for (String scheme : IPluginContainer.INSTANCE.getFactoryTypes("org.eclipse.emf.cdo.common.util.uriHandlers")) {
                try {
                    URIHandler handler = (URIHandler)IPluginContainer.INSTANCE.getElement("org.eclipse.emf.cdo.common.util.uriHandlers", scheme, null);
                    this.addURIHandler(scheme, handler);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
            IPluginContainer.INSTANCE.getFactoryRegistry().addListener((IListener)new ContainerEventAdapter<Map.Entry<IFactoryKey, IFactory>>(){

                protected void onAdded(IContainer<Map.Entry<IFactoryKey, IFactory>> container, Map.Entry<IFactoryKey, IFactory> element) {
                    String scheme = this.getScheme(element);
                    if (scheme != null) {
                        URIHandler handler = (URIHandler)IPluginContainer.INSTANCE.getElement("org.eclipse.emf.cdo.common.util.uriHandlers", scheme, null);
                        URIHandlerRegistryImpl.this.addURIHandler(scheme, handler);
                    }
                }

                protected void onRemoved(IContainer<Map.Entry<IFactoryKey, IFactory>> container, Map.Entry<IFactoryKey, IFactory> element) {
                    String scheme = this.getScheme(element);
                    if (scheme != null) {
                        URIHandlerRegistryImpl.this.removeURIHandler(scheme);
                    }
                }

                private String getScheme(Map.Entry<IFactoryKey, IFactory> element) {
                    IFactoryKey key = element.getKey();
                    if ("org.eclipse.emf.cdo.common.util.uriHandlers".equals(key.getProductGroup())) {
                        return key.getType();
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public synchronized URIHandler addURIHandler(String scheme, URIHandler handler) {
        this.initialize();
        return this.handlers.put(scheme, handler);
    }

    @Override
    public synchronized URIHandler removeURIHandler(String scheme) {
        this.initialize();
        return this.handlers.remove(scheme);
    }

    @Override
    public synchronized URIHandler getURIHandler(String scheme) {
        this.initialize();
        return this.handlers.get(scheme);
    }

    private URIHandler getHandler(URI uri) {
        return this.getURIHandler(uri.scheme());
    }

    public boolean canHandle(URI uri) {
        URIHandler handler = this.getHandler(uri);
        return handler != null && handler.canHandle(uri);
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        return this.getHandler(uri).exists(uri, options);
    }

    public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
        return this.getHandler(uri).contentDescription(uri, options);
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        return this.getHandler(uri).getAttributes(uri, options);
    }

    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
        this.getHandler(uri).setAttributes(uri, attributes, options);
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        return this.getHandler(uri).createInputStream(uri, options);
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        return this.getHandler(uri).createOutputStream(uri, options);
    }

    public void delete(URI uri, Map<?, ?> options) throws IOException {
        this.getHandler(uri).delete(uri, options);
    }
}

