/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.IFileHandle;

public class ExternalEntryFile
extends PlatformObject
implements IStorage {
    private IFileHandle file;

    public ExternalEntryFile(IFileHandle file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.file = file;
    }

    public InputStream getContents() throws CoreException {
        try {
            return new BufferedInputStream(this.file.openInputStream(null));
        }
        catch (IOException e) {
            throw new ModelException(e, 985);
        }
    }

    public IPath getFullPath() {
        return this.file.getPath();
    }

    public String getName() {
        return this.file.getName();
    }

    public boolean isReadOnly() {
        return true;
    }

    public String toString() {
        return "ExternalEntryFile[" + this.file.toOSString() + "]";
    }

    public <T> T getAdapter(Class<T> adapter) {
        Object rv = super.getAdapter(adapter);
        if (rv != null) {
            return (T)rv;
        }
        return (T)Platform.getAdapterManager().getAdapter((Object)this.file, adapter);
    }
}

