/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.php.core.util.INamespaceResolver;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.util.DefaultNamespaceResolver;

public class ConfiguredNamespaceResolver
implements INamespaceResolver {
    private static final String EXT_ID = "org.eclipse.php.core.namespaceResolver";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_PRIORITY = "priority";
    private INamespaceResolver[] resolvers;
    private IProject project;

    public ConfiguredNamespaceResolver(IProject project) {
        this.init(project);
    }

    private void lazyResolvers() {
        if (this.resolvers != null) {
            return;
        }
        DefaultNamespaceResolver defaultResolver = new DefaultNamespaceResolver();
        defaultResolver.init(this.project);
        if (this.project == null) {
            this.resolvers = new INamespaceResolver[]{defaultResolver};
        } else {
            ArrayList<INamespaceResolver> resolverList = new ArrayList<INamespaceResolver>();
            HashMap<INamespaceResolver, Integer> priorities = new HashMap<INamespaceResolver, Integer>();
            IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXT_ID);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    INamespaceResolver tmp = (INamespaceResolver)element.createExecutableExtension(ATTR_CLASS);
                    tmp.init(this.project);
                    if (tmp != null && tmp.isSupported()) {
                        resolverList.add(tmp);
                        priorities.put(tmp, Integer.decode(element.getAttribute(ATTR_PRIORITY)));
                    }
                }
                catch (CoreException e) {
                    PHPCorePlugin.log(e);
                }
                ++n2;
            }
            Collections.sort(resolverList, (o1, o2) -> Integer.compare((Integer)priorities.get(o1), (Integer)priorities.get(o2)) * -1);
            resolverList.add(defaultResolver);
            this.resolvers = resolverList.toArray(new INamespaceResolver[0]);
        }
    }

    @Override
    public String resolveNamespace(IPath folder) {
        this.lazyResolvers();
        INamespaceResolver[] iNamespaceResolverArray = this.resolvers;
        int n = this.resolvers.length;
        int n2 = 0;
        while (n2 < n) {
            INamespaceResolver resolver = iNamespaceResolverArray[n2];
            String result = resolver.resolveNamespace(folder);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IPath resolveLocation(IPath target, String namespace) {
        this.lazyResolvers();
        INamespaceResolver[] iNamespaceResolverArray = this.resolvers;
        int n = this.resolvers.length;
        int n2 = 0;
        while (n2 < n) {
            INamespaceResolver resolver = iNamespaceResolverArray[n2];
            IPath result = resolver.resolveLocation(target, namespace);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public void init(IProject project) {
        this.project = project;
        this.resolvers = null;
    }
}

