/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class NetworkUtil {
    private static Inet4Address CLASS_A_NETWORK;
    private static Inet4Address CLASS_B_NETWORK;
    private static Inet4Address CLASS_C_NETWORK;
    private static Inet4Address LOOPBACK_NETWORK;
    public static Inet4Address LOCALHOST;
    private static final String[] WHAT_IS_MY_IP_CALLBACKS;
    private static final int WHAT_IS_MY_IP_CONNECTION_TIMEOUT = 1000;
    private static final int WHAT_IS_MY_IP_READ_TIMEOUT = 5000;
    public static final int TYPE_PUBLIC = 1;
    public static final int TYPE_PRIVATE = 2;
    public static final int TYPE_LOOPBACK = 4;
    private static final Pattern IPV4_PATTERN;

    static {
        try {
            CLASS_A_NETWORK = (Inet4Address)InetAddress.getByName("10.0.0.0");
            CLASS_B_NETWORK = (Inet4Address)InetAddress.getByName("172.16.0.0");
            CLASS_C_NETWORK = (Inet4Address)InetAddress.getByName("192.168.0.0");
            LOOPBACK_NETWORK = (Inet4Address)InetAddress.getByName("127.0.0.0");
            LOCALHOST = (Inet4Address)InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException unknownHostException) {}
        WHAT_IS_MY_IP_CALLBACKS = new String[]{"http://checkip.amazonaws.com", "http://icanhazip.com", "http://www.trackip.net/ip"};
        IPV4_PATTERN = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
    }

    private NetworkUtil() {
    }

    public static List<Inet4Address> getAllAddresses() {
        ArrayList<Inet4Address> descriptors = new ArrayList<Inet4Address>();
        Inet4Address publicAddress = NetworkUtil.getPublicAddress();
        if (publicAddress != null) {
            descriptors.add(NetworkUtil.getPublicAddress());
        }
        descriptors.addAll(NetworkUtil.getPrivateAddresses());
        descriptors.add(LOCALHOST);
        return descriptors;
    }

    /*
     * Unable to fully structure code
     */
    public static Inet4Address getPublicAddress() {
        var3 = NetworkUtil.WHAT_IS_MY_IP_CALLBACKS;
        var2_1 = NetworkUtil.WHAT_IS_MY_IP_CALLBACKS.length;
        var1_2 = 0;
        while (var1_2 < var2_1) {
            block13: {
                callback = var3[var1_2];
                bufferedReader = null;
                whatismyip = new URL(callback);
                connection = whatismyip.openConnection();
                connection.setConnectTimeout(1000);
                connection.setReadTimeout(5000);
                bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                publicIP = bufferedReader.readLine();
                var9_8 = NetworkUtil.getByName(publicIP, 2000);
                if (bufferedReader == null) break block13;
                try {
                    bufferedReader.close();
                }
                catch (IOException v0) {}
            }
            return var9_8;
            catch (Exception v1) {
                try {
                    ** if (bufferedReader == null) goto lbl-1000
                }
                catch (Throwable var8_9) {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException v3) {}
                    }
                    throw var8_9;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException v2) {}
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            ++var1_2;
        }
        return null;
    }

    public static List<Inet4Address> getPrivateAddresses() {
        ArrayList<Inet4Address> descriptors = new ArrayList<Inet4Address>();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (networkInterface.getDisplayName().contains("VMware")) continue;
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (!(inetAddress instanceof Inet4Address) || inetAddress.isLoopbackAddress()) continue;
                    descriptors.add((Inet4Address)inetAddress);
                }
            }
        }
        catch (Exception exception) {}
        return descriptors;
    }

    public static int getType(Inet4Address address) {
        if (address.isLoopbackAddress()) {
            return 4;
        }
        if (NetworkUtil.isPrivateClassA(address) || NetworkUtil.isPrivateClassB(address) || NetworkUtil.isPrivateClassC(address)) {
            return 2;
        }
        return 1;
    }

    public static Inet4Address getByName(String host, int timeout) {
        DNSJob resolver = new DNSJob(host);
        resolver.schedule();
        try {
            resolver.join(timeout, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (InterruptedException interruptedException) {}
        return resolver.getAddress();
    }

    public static boolean isPrivateClassA(Inet4Address address) {
        return NetworkUtil.isInRange(address, CLASS_A_NETWORK, 8);
    }

    public static boolean isPrivateClassB(Inet4Address address) {
        return NetworkUtil.isInRange(address, CLASS_B_NETWORK, 12);
    }

    public static boolean isPrivateClassC(Inet4Address address) {
        return NetworkUtil.isInRange(address, CLASS_C_NETWORK, 16);
    }

    public static boolean isLoopbackAddress(Inet4Address address) {
        return NetworkUtil.isInRange(address, LOOPBACK_NETWORK, 8);
    }

    public static boolean isSamePrivateClass(Inet4Address address1, Inet4Address address2) {
        return NetworkUtil.isPrivateClassA(address1) && NetworkUtil.isPrivateClassA(address2) || NetworkUtil.isPrivateClassB(address1) && NetworkUtil.isPrivateClassB(address2) || NetworkUtil.isPrivateClassC(address1) && NetworkUtil.isPrivateClassC(address2);
    }

    public static boolean isSameNetwork(Inet4Address address1, Inet4Address address2, int mask) {
        int address2Value;
        int maskValue = 0xFFFFFFF << 32 - mask;
        int address1Value = NetworkUtil.getAddress(address1.getAddress());
        return (address1Value & maskValue) == ((address2Value = NetworkUtil.getAddress(address2.getAddress())) & maskValue);
    }

    public static boolean isIPv4Address(String input) {
        return IPV4_PATTERN.matcher(input).matches();
    }

    private static boolean isInRange(Inet4Address address, Inet4Address subnet, int mask) {
        int addressValue;
        int maskValue = 0xFFFFFFF << 32 - mask;
        int subnetValue = NetworkUtil.getAddress(subnet.getAddress());
        return (subnetValue & subnetValue) == ((addressValue = NetworkUtil.getAddress(address.getAddress())) & maskValue);
    }

    private static int getAddress(byte[] bytesAddress) {
        return (bytesAddress[0] & 0xFF) << 24 | (bytesAddress[1] & 0xFF) << 16 | (bytesAddress[2] & 0xFF) << 8 | (bytesAddress[3] & 0xFF) << 0;
    }

    private static class DNSJob
    extends Job {
        private String host;
        private Inet4Address address;

        public DNSJob(String host) {
            super("");
            this.host = host;
            this.setSystem(true);
            this.setUser(false);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.setAddress((Inet4Address)Inet4Address.getByName(this.host));
            }
            catch (UnknownHostException unknownHostException) {}
            return Status.OK_STATUS;
        }

        synchronized Inet4Address getAddress() {
            return this.address;
        }

        synchronized void setAddress(Inet4Address address) {
            this.address = address;
        }
    }
}

