/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective;

import java.util.Hashtable;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormTool;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormToolProperties;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormToolPropertiesInterface;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.ToolManager;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.SelectFindToolAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.MultipleFormToolPropertiesInterface;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;

public class RegFindTool
extends FormTool
implements MultipleFormToolPropertiesInterface {
    public RegFindTool(ToolManager toolManager, String alt) {
        super(toolManager, "uddi/images/find_enabled.gif", "uddi/images/find_highlighted.gif", alt);
    }

    @Override
    protected final void initDefaultProperties() {
        this.initDefaultProperties(this);
        this.setProperty("subQueryKey", "");
        this.setProperty("subQueriesProperties", new Hashtable());
        UDDIPerspective uddiPerspective = this.toolManager_.getNode().getNodeManager().getController().getUDDIPerspective();
        this.setProperty("queryName", uddiPerspective.getMessage("DEFAULT_QUERY_NAME"));
    }

    private final void initDefaultProperties(FormToolPropertiesInterface formToolPI) {
        this.toolManager_.getNode().getNodeManager().getController().getUDDIPerspective();
        formToolPI.setProperty("queryItem", String.valueOf(0));
        String simpleStyleString = String.valueOf(0);
        formToolPI.setProperty("queryStyleBusinesses", simpleStyleString);
        formToolPI.setProperty("queryStyleServices", simpleStyleString);
        formToolPI.setProperty("queryStyleServiceInterfaces", simpleStyleString);
        String maxSearchSet = String.valueOf(100);
        String maxResults = String.valueOf(10);
        formToolPI.setProperty("simpleBusinessName", "");
        formToolPI.setProperty("advancedBusinessMaxSearchSet", maxSearchSet);
        formToolPI.setProperty("advancedBusinessMaxResults", maxResults);
        formToolPI.setProperty("simpleServiceName", "");
        formToolPI.setProperty("advancedServiceMaxSearchSet", maxSearchSet);
        formToolPI.setProperty("advancedServiceMaxResults", maxResults);
        formToolPI.setProperty("simpleServiceInterfaceName", "");
        formToolPI.setProperty("advancedServiceInterfaceName", "");
        formToolPI.setProperty("advancedServiceInterfaceMaxSearchSet", maxSearchSet);
        formToolPI.setProperty("advancedServiceInterfaceMaxResults", maxResults);
    }

    public final void addAuthenticationProperties(RegistryElement regElement) {
        String publishURL = regElement.getPublishURL();
        String userId = regElement.getUserId();
        String password = regElement.getCred();
        if (publishURL == null) {
            publishURL = "";
        }
        if (userId == null) {
            userId = "";
        }
        if (password == null) {
            password = "";
        }
        this.setProperty("advancedPublishURL", publishURL);
        this.setProperty("advancedUserId", userId);
        this.setProperty("advancedPassword", password);
    }

    @Override
    public final FormToolPropertiesInterface getFormToolProperties(Object subQueryKeyObject) {
        String subQueryKey = (String)subQueryKeyObject;
        if (subQueryKey == null || subQueryKey.length() < 1) {
            return this;
        }
        Hashtable subQueriesProperties = (Hashtable)this.getProperty("subQueriesProperties");
        FormToolPropertiesInterface subQueryProperties = (FormToolPropertiesInterface)subQueriesProperties.get(subQueryKey);
        if (subQueryProperties == null) {
            subQueryProperties = new FormToolProperties();
            this.initDefaultProperties(subQueryProperties);
            subQueriesProperties.put(subQueryKey, subQueryProperties);
        }
        return subQueryProperties;
    }

    @Override
    public String getSelectToolActionHref(boolean forHistory) {
        Node node = this.toolManager_.getNode();
        String subQueryKey = (String)this.getProperty("subQueryKey");
        return SelectFindToolAction.getActionLink(node.getNodeId(), this.toolId_, node.getViewId(), node.getViewToolId(), subQueryKey, forHistory);
    }

    @Override
    public String getFormLink() {
        Object subQueryKeyObject = this.getProperty("subQueryKey");
        if (subQueryKeyObject != null) {
            boolean isSubQueryGet;
            this.getProperty("subQueriesProperties");
            FormToolPropertiesInterface subQueryProperties = this.getFormToolProperties(subQueryKeyObject);
            Object subQueryGetObject = subQueryProperties.getProperty("subQueryGet");
            if (subQueryGetObject != null && (isSubQueryGet = ((Boolean)subQueryGetObject).booleanValue())) {
                return "uddi/forms/GetForm.jsp";
            }
        }
        return "uddi/forms/RegFindForm.jsp";
    }
}

