/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.entity;

import java.util.function.BiConsumer;
import org.eclipse.scout.sdk.core.java.model.api.IClasspathEntry;
import org.eclipse.scout.sdk.core.java.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.form.FormNewOperation;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.page.PageNewOperation;
import org.eclipse.scout.sdk.core.s.service.ServiceNewOperation;
import org.eclipse.scout.sdk.core.s.util.ScoutTier;
import org.eclipse.scout.sdk.core.util.Ensure;

public class EntityNewOperation
implements BiConsumer<IEnvironment, IProgress> {
    private String m_entityName;
    private String m_clientPackage;
    private String m_sharedPackage;
    private String m_serverPackage;
    private IClasspathEntry m_clientSourceFolder;
    private IClasspathEntry m_sharedSourceFolder;
    private IClasspathEntry m_serverSourceFolder;
    private IClasspathEntry m_sharedGeneratedSourceFolder;
    private IClasspathEntry m_clientTestSourceFolder;
    private IClasspathEntry m_sharedTestSourceFolder;
    private IClasspathEntry m_serverTestSourceFolder;
    private IClasspathEntry m_clientMainTestSourceFolder;
    private IClasspathEntry m_sharedMainTestSourceFolder;
    private IClasspathEntry m_serverMainTestSourceFolder;
    private FormNewOperation m_formNewOperation;
    private PageNewOperation m_pageNewOperation;
    private ServiceNewOperation m_serviceNewOperation;

    @Override
    public void accept(IEnvironment env, IProgress progress) {
        this.validateOperation();
        this.prepareOperation();
        this.prepareProgress(progress);
        this.executeOperation(env, progress);
    }

    protected void validateOperation() {
        Ensure.notBlank((CharSequence)this.getEntityName(), (CharSequence)"No entity name provided", (Object[])new Object[0]);
        Ensure.notBlank((CharSequence)this.getClientPackage(), (CharSequence)"No client package provided", (Object[])new Object[0]);
    }

    protected void prepareOperation() {
        this.setSharedPackage(ScoutTier.Client.convert(ScoutTier.Shared, this.getClientPackage()));
        this.setServerPackage(ScoutTier.Client.convert(ScoutTier.Server, this.getClientPackage()));
    }

    protected void prepareProgress(IProgress progress) {
        progress.init(this.getTotalWork(), this.toString(), new Object[0]);
    }

    protected void executeOperation(IEnvironment env, IProgress progress) {
        boolean runServiceNewOperation = this.runServiceNewOperation();
        if (runServiceNewOperation) {
            this.setServiceNewOperation(this.createServiceNewOperation());
            this.prepareServiceNewOperation();
        }
        this.setFormNewOperation(this.createFormNewOperation());
        if (this.prepareFormNewOperation()) {
            this.getFormNewOperation().accept(env, progress.newChild(1));
        }
        this.setPageNewOperation(this.createPageNewOperation());
        if (this.preparePageNewOperation()) {
            this.getPageNewOperation().accept(env, progress.newChild(1));
        }
        if (runServiceNewOperation) {
            this.getServiceNewOperation().accept(env, progress.newChild(1));
        }
    }

    protected int getTotalWork() {
        int result = 1;
        ++result;
        if (this.runServiceNewOperation()) {
            ++result;
        }
        return result;
    }

    protected static void warnMissingInputFor(String element, String input) {
        SdkLog.warning((CharSequence)"No {} will be created, because the {} was not provided or could not be determined.", (Object[])new Object[]{element, input});
    }

    protected static boolean requireInputFor(String element, String input, Object inputObj, boolean warn) {
        if (inputObj != null) {
            return true;
        }
        if (warn) {
            EntityNewOperation.warnMissingInputFor(element, input);
        }
        return false;
    }

    protected boolean requireClientPackageFor(String element, boolean warn) {
        return EntityNewOperation.requireInputFor(element, "client package", this.getClientPackage(), warn);
    }

    protected boolean requireSharedPackageFor(String element, boolean warn) {
        return EntityNewOperation.requireInputFor(element, "shared package", this.getSharedPackage(), warn);
    }

    protected boolean requireClientSourceFolderFor(String element, boolean warn) {
        return EntityNewOperation.requireInputFor(element, "client source folder", this.getClientSourceFolder(), warn);
    }

    protected boolean requireSharedSourceFolderFor(String element, boolean warn) {
        return EntityNewOperation.requireInputFor(element, "shared source folder", this.getSharedSourceFolder(), warn);
    }

    protected boolean requireServerSourceFolderFor(String element, boolean warn) {
        return EntityNewOperation.requireInputFor(element, "server source folder", this.getServerSourceFolder(), warn);
    }

    protected FormNewOperation createFormNewOperation() {
        return new FormNewOperation();
    }

    protected boolean checkFormNewOperationPrerequisites(boolean warn) {
        if (!this.requireClientPackageFor("Form", warn)) {
            return false;
        }
        return this.requireClientSourceFolderFor("Form", warn);
    }

    protected boolean prepareFormNewOperation() {
        FormNewOperation op = this.getFormNewOperation();
        if (op == null) {
            return false;
        }
        if (!this.checkFormNewOperationPrerequisites(true)) {
            return false;
        }
        op.setFormName(this.getEntityName().concat("Form"));
        op.setSuperType(this.getFormSuperType(this.getClientSourceFolder().javaEnvironment()));
        op.setClientPackage(this.getClientPackage());
        op.setClientSourceFolder(this.getClientSourceFolder());
        op.setClientTestSourceFolder(this.getClientTestSourceFolder());
        op.setSharedSourceFolder(this.getSharedSourceFolder());
        op.setFormDataSourceFolder(this.getSharedGeneratedSourceFolder() != null ? this.getSharedGeneratedSourceFolder() : this.getSharedSourceFolder());
        if (this.getServerSourceFolder() != null) {
            op.setServerSession(((IScoutApi)this.getServerSourceFolder().javaEnvironment().requireApi(IScoutApi.class)).IServerSession().fqn());
        }
        op.setServerSourceFolder(this.getServerSourceFolder());
        op.setServerTestSourceFolder(this.getServerTestSourceFolder());
        op.setCreateFormData(this.getSharedSourceFolder() != null);
        op.setCreatePermissions(this.getSharedSourceFolder() != null);
        op.setCreateOrAppendService(this.getSharedSourceFolder() != null && this.getServerSourceFolder() != null);
        op.setServiceNewOperation(this.getServiceNewOperation());
        return true;
    }

    protected String getFormSuperType(IJavaEnvironment javaEnv) {
        return ((IScoutApi)javaEnv.api(IScoutApi.class).orElseThrow()).AbstractForm().fqn();
    }

    protected PageNewOperation createPageNewOperation() {
        return new PageNewOperation();
    }

    protected boolean checkPageNewOperationPrerequisites(boolean warn) {
        if (!this.requireClientPackageFor("Page", warn)) {
            return false;
        }
        return this.requireClientSourceFolderFor("Page", warn);
    }

    protected boolean preparePageNewOperation() {
        PageNewOperation op = this.getPageNewOperation();
        if (op == null) {
            return false;
        }
        if (!this.checkPageNewOperationPrerequisites(true)) {
            return false;
        }
        op.setPageName(this.getEntityName().concat("TablePage"));
        op.setSuperType(this.getPageSuperType(this.getClientSourceFolder().javaEnvironment()));
        op.setPackage(this.getClientPackage());
        op.setClientSourceFolder(this.getClientSourceFolder());
        op.setSharedSourceFolder(this.getSharedSourceFolder());
        op.setPageDataSourceFolder(this.getSharedGeneratedSourceFolder() != null ? this.getSharedGeneratedSourceFolder() : this.getSharedSourceFolder());
        if (this.getServerSourceFolder() != null) {
            op.setServerSession(((IScoutApi)this.getServerSourceFolder().javaEnvironment().requireApi(IScoutApi.class)).IServerSession().fqn());
        }
        op.setServerSourceFolder(this.getServerSourceFolder());
        op.setTestSourceFolder(this.getServerTestSourceFolder());
        op.setCreateAbstractPage(false);
        op.setServiceNewOperation(this.getServiceNewOperation());
        return true;
    }

    protected String getPageSuperType(IJavaEnvironment javaEnv) {
        return ((IScoutApi)javaEnv.api(IScoutApi.class).orElseThrow()).AbstractPageWithTable().fqn();
    }

    protected ServiceNewOperation createServiceNewOperation() {
        return new ServiceNewOperation();
    }

    protected boolean checkServiceNewOperationPrerequisites(boolean warn) {
        if (!this.requireSharedPackageFor("Service", warn)) {
            return false;
        }
        if (!this.requireSharedSourceFolderFor("Service", warn)) {
            return false;
        }
        return this.requireServerSourceFolderFor("Service", warn);
    }

    protected boolean prepareServiceNewOperation() {
        ServiceNewOperation op = this.getServiceNewOperation();
        if (op == null) {
            return false;
        }
        if (!this.checkServiceNewOperationPrerequisites(false)) {
            return false;
        }
        op.setServiceName(this.getEntityName());
        op.setSharedPackage(this.getSharedPackage());
        op.setSharedSourceFolder(this.getSharedSourceFolder());
        op.setServerSourceFolder(this.getServerSourceFolder());
        op.setTestSourceFolder(this.getServerTestSourceFolder());
        if (this.getServerSourceFolder() != null) {
            op.setServerSession(((IScoutApi)this.getServerSourceFolder().javaEnvironment().requireApi(IScoutApi.class)).IServerSession().fqn());
        }
        op.setCreateTest(this.getServerTestSourceFolder() != null);
        return true;
    }

    public boolean runServiceNewOperation() {
        return this.isCreateSingleService() && this.checkServiceNewOperationPrerequisites(false);
    }

    protected boolean isCreateSingleService() {
        return true;
    }

    public String getEntityName() {
        return this.m_entityName;
    }

    public void setEntityName(String entityName) {
        this.m_entityName = entityName;
    }

    public String getClientPackage() {
        return this.m_clientPackage;
    }

    public void setClientPackage(String clientPackage) {
        this.m_clientPackage = clientPackage;
    }

    public String getSharedPackage() {
        return this.m_sharedPackage;
    }

    protected void setSharedPackage(String sharedPackage) {
        this.m_sharedPackage = sharedPackage;
    }

    public String getServerPackage() {
        return this.m_serverPackage;
    }

    protected void setServerPackage(String serverPackage) {
        this.m_serverPackage = serverPackage;
    }

    public IClasspathEntry getClientSourceFolder() {
        return this.m_clientSourceFolder;
    }

    public void setClientSourceFolder(IClasspathEntry clientSourceFolder) {
        this.m_clientSourceFolder = clientSourceFolder;
    }

    public IClasspathEntry getClientTestSourceFolder() {
        return this.m_clientTestSourceFolder;
    }

    public void setClientTestSourceFolder(IClasspathEntry clientTestSourceFolder) {
        this.m_clientTestSourceFolder = clientTestSourceFolder;
    }

    public IClasspathEntry getSharedSourceFolder() {
        return this.m_sharedSourceFolder;
    }

    public void setSharedSourceFolder(IClasspathEntry sharedSourceFolder) {
        this.m_sharedSourceFolder = sharedSourceFolder;
    }

    public IClasspathEntry getSharedTestSourceFolder() {
        return this.m_sharedTestSourceFolder;
    }

    public void setSharedTestSourceFolder(IClasspathEntry sharedTestSourceFolder) {
        this.m_sharedTestSourceFolder = sharedTestSourceFolder;
    }

    public IClasspathEntry getServerSourceFolder() {
        return this.m_serverSourceFolder;
    }

    public void setServerSourceFolder(IClasspathEntry serverSourceFolder) {
        this.m_serverSourceFolder = serverSourceFolder;
    }

    public IClasspathEntry getServerTestSourceFolder() {
        return this.m_serverTestSourceFolder;
    }

    public void setServerTestSourceFolder(IClasspathEntry serverTestSourceFolder) {
        this.m_serverTestSourceFolder = serverTestSourceFolder;
    }

    public IClasspathEntry getClientMainTestSourceFolder() {
        return this.m_clientMainTestSourceFolder;
    }

    public void setClientMainTestSourceFolder(IClasspathEntry clientMainTestSourceFolder) {
        this.m_clientMainTestSourceFolder = clientMainTestSourceFolder;
    }

    public IClasspathEntry getSharedMainTestSourceFolder() {
        return this.m_sharedMainTestSourceFolder;
    }

    public void setSharedMainTestSourceFolder(IClasspathEntry sharedMainTestSourceFolder) {
        this.m_sharedMainTestSourceFolder = sharedMainTestSourceFolder;
    }

    public IClasspathEntry getServerMainTestSourceFolder() {
        return this.m_serverMainTestSourceFolder;
    }

    public void setServerMainTestSourceFolder(IClasspathEntry serverMainTestSourceFolder) {
        this.m_serverMainTestSourceFolder = serverMainTestSourceFolder;
    }

    public IClasspathEntry getSharedGeneratedSourceFolder() {
        return this.m_sharedGeneratedSourceFolder;
    }

    public void setSharedGeneratedSourceFolder(IClasspathEntry sharedGeneratedSourceFolder) {
        this.m_sharedGeneratedSourceFolder = sharedGeneratedSourceFolder;
    }

    public FormNewOperation getFormNewOperation() {
        return this.m_formNewOperation;
    }

    protected void setFormNewOperation(FormNewOperation formNewOperation) {
        this.m_formNewOperation = formNewOperation;
    }

    public PageNewOperation getPageNewOperation() {
        return this.m_pageNewOperation;
    }

    protected void setPageNewOperation(PageNewOperation pageNewOperation) {
        this.m_pageNewOperation = pageNewOperation;
    }

    public ServiceNewOperation getServiceNewOperation() {
        return this.m_serviceNewOperation;
    }

    protected void setServiceNewOperation(ServiceNewOperation serviceNewOperation) {
        this.m_serviceNewOperation = serviceNewOperation;
    }

    public String toString() {
        return "Create new Entity";
    }
}

