/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.SymbolEntry;
import org.eclipse.core.runtime.IPath;

public final class ScannerConfigUtil {
    public static boolean scAddSymbolsList2SymbolEntryMap(Map<String, SymbolEntry> sumSymbols, List<String> symbols, boolean active) {
        boolean rc = false;
        for (String symbol : symbols) {
            String key;
            String value = null;
            int index = symbol.indexOf("=");
            if (index != -1) {
                key = symbol.substring(0, index).trim();
                value = symbol.substring(index + 1).trim();
            } else {
                key = symbol.trim();
            }
            SymbolEntry sEntry = sumSymbols.get(key);
            if (sEntry == null) {
                sEntry = new SymbolEntry(key, value, true);
                rc = true;
            } else {
                rc |= sEntry.add(value, active);
            }
            sumSymbols.put(key, sEntry);
        }
        return rc;
    }

    public static List<String> scSymbolsSymbolEntryMap2List(Map<String, SymbolEntry> sumSymbols, boolean active) {
        Set<Map.Entry<String, SymbolEntry>> symbols = sumSymbols.entrySet();
        ArrayList<String> rv = new ArrayList<String>(symbols.size());
        for (Map.Entry<String, SymbolEntry> symbol : symbols) {
            SymbolEntry sEntry = symbol.getValue();
            if (active) {
                rv.addAll(sEntry.getActiveRaw());
                continue;
            }
            rv.addAll(sEntry.getRemovedRaw());
        }
        return rv;
    }

    public static Map<String, String> scSymbolEntryMap2Map(Map<String, SymbolEntry> sumSymbols) {
        HashMap<String, String> rv = new HashMap<String, String>();
        Set<String> keys = sumSymbols.keySet();
        for (String key : keys) {
            SymbolEntry entries = sumSymbols.get(key);
            List<String> values = entries.getValuesOnly(true);
            for (String value : values) {
                rv.put(key, value);
            }
        }
        return rv;
    }

    public static boolean scAddSymbolString2SymbolEntryMap(Map<String, SymbolEntry> symbols, String symbol, boolean active) {
        String key;
        boolean rc = false;
        String value = null;
        int index = symbol.indexOf("=");
        if (index != -1) {
            key = ScannerConfigUtil.getSymbolKey(symbol);
            value = ScannerConfigUtil.getSymbolValue(symbol);
        } else {
            key = symbol.trim();
        }
        SymbolEntry sEntry = symbols.get(key);
        if (sEntry == null) {
            sEntry = new SymbolEntry(key, value, active);
            rc = true;
        } else {
            rc |= sEntry.add(value, active);
        }
        symbols.put(key, sEntry);
        return rc;
    }

    public static boolean scAddSymbolEntryMap2SymbolEntryMap(Map<String, SymbolEntry> result, Map<String, SymbolEntry> addend) {
        boolean rc = false;
        Set<String> keySet = addend.keySet();
        for (String key : keySet) {
            if (result.keySet().contains(key)) {
                SymbolEntry rSE = result.get(key);
                SymbolEntry aSE = addend.get(key);
                List<String> activeValues = rSE.getActiveRaw();
                for (String aValue : aSE.getActiveRaw()) {
                    if (activeValues.contains(aValue)) continue;
                    rSE.add(ScannerConfigUtil.getSymbolValue(aValue), true);
                    rc |= true;
                }
                List<String> removedValues = rSE.getRemovedRaw();
                for (String aValue : aSE.getRemovedRaw()) {
                    if (removedValues.contains(aValue)) continue;
                    rSE.add(ScannerConfigUtil.getSymbolValue(aValue), false);
                    rc |= true;
                }
                continue;
            }
            SymbolEntry aSymbolEntry = addend.get(key);
            result.put(key, aSymbolEntry);
            rc |= true;
        }
        return rc;
    }

    public static String getSymbolKey(String symbol) {
        int index = symbol.indexOf(61);
        if (index != -1) {
            return symbol.substring(0, index).trim();
        }
        return symbol;
    }

    public static String getSymbolValue(String symbol) {
        int index = symbol.indexOf(61);
        if (index != -1) {
            return symbol.substring(index + 1).trim();
        }
        return null;
    }

    public static void removeSymbolEntryValue(String symbol, Map<String, SymbolEntry> symbolEntryMap) {
        String key = ScannerConfigUtil.getSymbolKey(symbol);
        String value = ScannerConfigUtil.getSymbolValue(symbol);
        SymbolEntry se = symbolEntryMap.get(key);
        if (se != null) {
            se.remove(value);
            if (se.numberOfValues() == 0) {
                symbolEntryMap.remove(key);
            }
        }
    }

    public static LinkedHashMap<String, SymbolEntry> swapIncludePaths(LinkedHashMap<String, SymbolEntry> sumPaths, int index1, int index2) {
        int size = sumPaths.size();
        if (index1 == index2 || index1 < 0 || index1 >= size || index2 < 0 || index2 >= size) {
            return sumPaths;
        }
        ArrayList<String> pathKeyList = new ArrayList<String>(sumPaths.keySet());
        String temp1 = pathKeyList.get(index1);
        String temp2 = pathKeyList.get(index2);
        pathKeyList.set(index1, temp2);
        pathKeyList.set(index2, temp1);
        LinkedHashMap<String, SymbolEntry> newSumPaths = new LinkedHashMap<String, SymbolEntry>(sumPaths.size());
        for (String key : pathKeyList) {
            newSumPaths.put(key, sumPaths.get(key));
        }
        return newSumPaths;
    }

    public static String[] tokenizeStringWithQuotes(String line, String quoteStyle) {
        ArrayList<String> allTokens = new ArrayList<String>();
        String[] tokens = line.split(quoteStyle);
        int i = 0;
        while (i < tokens.length) {
            if (i % 2 == 0) {
                String[] sTokens = tokens[i].split("\\s+");
                int j = 0;
                while (j < sTokens.length) {
                    allTokens.add(sTokens[j++]);
                }
            } else {
                allTokens.add(tokens[i]);
            }
            ++i;
        }
        return allTokens.toArray(new String[allTokens.size()]);
    }

    public static String[] iPathArray2StringArray(IPath[] paths) {
        String[] rv = new String[paths.length];
        int i = 0;
        while (i < paths.length) {
            rv[i] = paths[i].toString();
            ++i;
        }
        return rv;
    }
}

