/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.core.OptionStringValue;
import org.eclipse.cdt.managedbuilder.internal.core.Option;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class BuildSettingsUtil {
    private static final int[] COMMON_SETTINGS_IDS = new int[]{4, 5, 6, 7, 8, 9, 10, 11};

    public static void disconnectDepentents(IConfiguration cfg, ITool[] tools) {
        int i = 0;
        while (i < tools.length) {
            BuildSettingsUtil.disconnectDepentents(cfg, tools[i]);
            ++i;
        }
    }

    public static void disconnectDepentents(IConfiguration cfg, ITool tool) {
        ITool[] deps = BuildSettingsUtil.getDependentTools(cfg, tool);
        int i = 0;
        while (i < deps.length) {
            BuildSettingsUtil.disconnect(deps[i], tool);
            ++i;
        }
    }

    private static void disconnect(ITool child, ITool superClass) {
        ITool directChild = child;
        while (directChild != null) {
            if (superClass.equals(directChild.getSuperClass())) break;
            directChild = directChild.getSuperClass();
        }
        if (directChild == null) {
            return;
        }
        ((Tool)directChild).copyNonoverriddenSettings((Tool)superClass);
        ((Tool)directChild).setSuperClass(superClass.getSuperClass());
    }

    public static ITool[] getDependentTools(IConfiguration cfg, ITool tool) {
        IResourceInfo[] rcInfos = cfg.getResourceInfos();
        ArrayList<ITool> list = new ArrayList<ITool>();
        int i = 0;
        while (i < rcInfos.length) {
            BuildSettingsUtil.calcDependentTools(rcInfos[i], tool, list);
            ++i;
        }
        return list.toArray(new Tool[list.size()]);
    }

    private static List<ITool> calcDependentTools(IResourceInfo info, ITool tool, List<ITool> list) {
        return BuildSettingsUtil.calcDependentTools(info.getTools(), tool, list);
    }

    public static List<ITool> calcDependentTools(ITool[] tools, ITool tool, List<ITool> list) {
        if (list == null) {
            list = new ArrayList<ITool>();
        }
        int i = 0;
        while (i < tools.length) {
            ITool superTool = tools[i];
            while (superTool != null) {
                if (superTool.equals(tool)) {
                    list.add(tools[i]);
                }
                superTool = superTool.getSuperClass();
            }
            ++i;
        }
        return list;
    }

    public static void copyCommonSettings(ITool fromTool, ITool toTool) {
        Tool fromT = (Tool)fromTool;
        Tool toT = (Tool)toTool;
        ArrayList<OptionStringValue> values = new ArrayList<OptionStringValue>();
        int i = 0;
        while (i < COMMON_SETTINGS_IDS.length) {
            int type = COMMON_SETTINGS_IDS[i];
            IOption[] toOptions = toT.getOptionsOfType(type);
            if (toOptions.length != 0) {
                IOption[] fromOptions = fromT.getOptionsOfType(type);
                values.clear();
                int k = 0;
                while (k < fromOptions.length) {
                    Option fromOption = (Option)fromOptions[k];
                    if (fromOption.getParent() == fromTool) {
                        List v = (List)fromOption.getExactValue();
                        values.addAll(v);
                    }
                    ++k;
                }
                if (values.size() != 0) {
                    OptionStringValue[] v;
                    IOption toOption = toOptions[0];
                    try {
                        v = toOption.getBasicStringListValueElements();
                        if (v.length != 0) {
                            values.addAll(Arrays.asList(v));
                        }
                    }
                    catch (BuildException e) {
                        ManagedBuilderCorePlugin.log(e);
                    }
                    v = values.toArray(new OptionStringValue[values.size()]);
                    IResourceInfo rcInfo = toTool.getParentResourceInfo();
                    ManagedBuildManager.setOption(rcInfo, (IHoldsOptions)toTool, toOption, v);
                    values.clear();
                }
            }
            ++i;
        }
    }

    public static boolean applyConfiguration(IConfiguration cfg, ICProjectDescription des, boolean force) throws CoreException {
        boolean updated = false;
        ICConfigurationDescription cfgDes = des.getConfigurationById(cfg.getId());
        if (cfgDes == null) {
            des.createConfiguration("org.eclipse.cdt.managedbuilder.core.configurationDataProvider", cfg.getConfigurationData());
            updated = true;
        } else if (force || cfg.isDirty()) {
            cfgDes.setConfigurationData("org.eclipse.cdt.managedbuilder.core.configurationDataProvider", cfg.getConfigurationData());
            updated = true;
        }
        return updated;
    }

    public static ICProjectDescription checkSynchBuildInfo(IProject project) throws CoreException {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project, false);
        if (info == null) {
            return null;
        }
        ICProjectDescription projDes = CoreModel.getDefault().getProjectDescription(project);
        return (projDes = BuildSettingsUtil.synchBuildInfo(info, projDes, false)).isModified() ? projDes : null;
    }

    public static ICProjectDescription synchBuildInfo(IManagedBuildInfo info, ICProjectDescription projDes, boolean force) throws CoreException {
        IManagedProject mProj = info.getManagedProject();
        IConfiguration[] cfgs = mProj.getConfigurations();
        ICConfigurationDescription[] cfgDess = projDes.getConfigurations();
        int i = 0;
        while (i < cfgs.length) {
            IConfiguration cfg = cfgs[i];
            BuildSettingsUtil.applyConfiguration(cfg, projDes, force);
            ++i;
        }
        i = 0;
        while (i < cfgDess.length) {
            ICConfigurationDescription cfgDes = cfgDess[i];
            IConfiguration cfg = mProj.getConfiguration(cfgDes.getId());
            if (cfg == null) {
                projDes.removeConfiguration(cfgDes);
            }
            ++i;
        }
        return projDes;
    }

    public static void checkApplyDescription(IProject project, ICProjectDescription des) throws CoreException {
        BuildSettingsUtil.checkApplyDescription(project, des, false);
    }

    public static void checkApplyDescription(IProject project, ICProjectDescription des, boolean avoidSerialization) throws CoreException {
        ICConfigurationDescription[] cfgs = des.getConfigurations();
        int i = 0;
        while (i < cfgs.length) {
            if (!"org.eclipse.cdt.managedbuilder.core.configurationDataProvider".equals(cfgs[i].getBuildSystemId())) {
                des.removeConfiguration(cfgs[i]);
            }
            ++i;
        }
        int flags = 0;
        if (avoidSerialization) {
            flags |= 2;
        }
        CoreModel.getDefault().getProjectDescriptionManager().setProjectDescription(project, des, flags, null);
    }

    public static ITool[] getToolsBySuperClassId(ITool[] tools, String id) {
        ArrayList<ITool> retTools = new ArrayList<ITool>();
        if (id != null) {
            int i = 0;
            while (i < tools.length) {
                ITool targetTool;
                ITool tool = targetTool = tools[i];
                do {
                    if (!id.equals(tool.getId())) continue;
                    retTools.add(targetTool);
                    break;
                } while ((tool = tool.getSuperClass()) != null);
                ++i;
            }
        }
        return retTools.toArray(new ITool[retTools.size()]);
    }
}

