/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.map.AbstractHashedMap;
import org.apache.commons.collections4.map.LinkedMap;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.tasks.ui.IBrandManager;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.graphics.Image;

public class BrandManager
implements IBrandManager {
    private final MultiValuedMap<String, String> brands = new HashSetValuedHashMap();
    private final MultiKeyMap<String, Image> brandingIcons = MultiKeyMap.multiKeyMap((AbstractHashedMap)new LinkedMap());
    private final MultiKeyMap<String, ImageDescriptor> overlayIcons = MultiKeyMap.multiKeyMap((AbstractHashedMap)new LinkedMap());
    private final MultiKeyMap<String, String> connectorLabels = MultiKeyMap.multiKeyMap((AbstractHashedMap)new LinkedMap());
    private final Map<String, Image> defaultBrandingIcons = new HashMap<String, Image>();
    private final Map<String, ImageDescriptor> defaultOverlayIcons = new HashMap<String, ImageDescriptor>();

    public void addBrandingIcon(String repositoryType, String brand, Image icon) {
        this.brands.put((Object)repositoryType, (Object)brand);
        this.brandingIcons.put((Object)repositoryType, (Object)brand, (Object)icon);
    }

    public void addOverlayIcon(String repositoryType, String brand, ImageDescriptor icon) {
        this.brands.put((Object)repositoryType, (Object)brand);
        this.overlayIcons.put((Object)repositoryType, (Object)brand, (Object)icon);
    }

    public void addConnectorLabel(String repositoryType, String brand, String label) {
        this.brands.put((Object)repositoryType, (Object)brand);
        this.connectorLabels.put((Object)repositoryType, (Object)brand, (Object)label);
    }

    public void addDefaultBrandingIcon(String repositoryType, Image icon) {
        this.defaultBrandingIcons.put(repositoryType, icon);
    }

    public void addDefaultOverlayIcon(String repositoryType, ImageDescriptor icon) {
        this.defaultOverlayIcons.put(repositoryType, icon);
    }

    @Override
    public Image getBrandingIcon(TaskRepository repository) {
        return this.getBrandingIcon(repository.getConnectorKind(), repository.getProperty("org.eclipse.mylyn.brand.id"));
    }

    @Override
    public ImageDescriptor getOverlayIcon(TaskRepository repository) {
        return this.getOverlayIcon(repository.getConnectorKind(), repository.getProperty("org.eclipse.mylyn.brand.id"));
    }

    @Override
    public ImageDescriptor getOverlayIcon(ITask task) {
        TaskRepository repository = this.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        if (repository != null) {
            return this.getOverlayIcon(repository);
        }
        return this.getDefaultOverlayIcon(task.getConnectorKind());
    }

    @Override
    public Image getBrandingIcon(String repositoryType, @Nullable String brand) {
        Image icon = (Image)this.brandingIcons.get((Object)repositoryType, (Object)brand);
        if (icon != null) {
            return icon;
        }
        return this.getDefaultBrandingIcon(repositoryType);
    }

    @Override
    public ImageDescriptor getOverlayIcon(String repositoryType, @Nullable String brand) {
        ImageDescriptor icon = (ImageDescriptor)this.overlayIcons.get((Object)repositoryType, (Object)brand);
        if (icon != null) {
            return icon;
        }
        return this.getDefaultOverlayIcon(repositoryType);
    }

    @Override
    public String getConnectorLabel(AbstractRepositoryConnector connector, @Nullable String brand) {
        String brandLabel = (String)this.connectorLabels.get((Object)connector.getConnectorKind(), (Object)brand);
        if (brandLabel != null) {
            return brandLabel;
        }
        return connector.getLabel();
    }

    @Override
    public Collection<String> getBrands(String connectorKind) {
        return this.brands.get((Object)connectorKind);
    }

    @Override
    public Image getDefaultBrandingIcon(String repositoryType) {
        return this.defaultBrandingIcons.get(repositoryType);
    }

    @Override
    public ImageDescriptor getDefaultOverlayIcon(String repositoryType) {
        return this.defaultOverlayIcons.get(repositoryType);
    }

    protected IRepositoryManager getRepositoryManager() {
        return TasksUi.getRepositoryManager();
    }
}

