/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions.breakpoints;

import org.eclipse.cdt.debug.internal.ui.CDebugUIUtils;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.IInternalCDebugUIConstants;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.breakpoints.AbstractBreakpointRulerAction;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class EnableDisableBreakpointRulerAction
extends AbstractBreakpointRulerAction {
    private IBreakpoint fBreakpoint;

    public EnableDisableBreakpointRulerAction(IWorkbenchPart part, IVerticalRulerInfo info) {
        super(part, info);
        this.setText(ActionMessages.getString("EnableDisableBreakpointRulerAction.Enable_Breakpoint_1") + "\t" + CDebugUIUtils.formatKeyBindingString(SWT.MOD2, ActionMessages.getString("CRulerToggleBreakpointAction_accelerator")));
        part.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem().setHelp((IAction)this, ICDebugHelpContextIds.ENABLE_DISABLE_BREAKPOINT_ACTION);
        this.setId(IInternalCDebugUIConstants.ACTION_ENABLE_DISABLE_BREAKPOINT);
    }

    public void run() {
        if (this.fBreakpoint != null) {
            try {
                this.fBreakpoint.setEnabled(!this.fBreakpoint.isEnabled());
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.getTargetPart().getSite().getShell(), (String)ActionMessages.getString("EnableDisableBreakpointRulerAction.Enabling_disabling_breakpoints_1"), (String)ActionMessages.getString("EnableDisableBreakpointRulerAction.Exceptions_occurred_enabling_or_disabling_breakpoint_1"), (IStatus)e.getStatus());
            }
        }
    }

    public void update() {
        this.fBreakpoint = this.getBreakpoint();
        this.setEnabled(this.fBreakpoint != null);
        if (this.isEnabled()) {
            try {
                if (this.getBreakpoint().isEnabled()) {
                    this.setText(ActionMessages.getString("EnableDisableBreakpointRulerAction.Disable_Breakpoint_1") + "\t" + CDebugUIUtils.formatKeyBindingString(SWT.MOD2, ActionMessages.getString("CRulerToggleBreakpointAction_accelerator")));
                } else {
                    this.setText(ActionMessages.getString("EnableDisableBreakpointRulerAction.Enable_Breakpoint_1") + "\t" + CDebugUIUtils.formatKeyBindingString(SWT.MOD2, ActionMessages.getString("CRulerToggleBreakpointAction_accelerator")));
                }
            }
            catch (CoreException e) {
                DebugPlugin.log((Throwable)e);
            }
        }
    }
}

