/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.overridemethods;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.internal.ui.refactoring.overridemethods.MethodCollector;
import org.eclipse.cdt.internal.ui.refactoring.overridemethods.VirtualMethodContainer;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.text.ITextSelection;

public class VirtualMethodsASTVisitor
extends ASTVisitor {
    private ITextSelection fSelection;
    private String fFileName;
    private VirtualMethodContainer fMethodContainer;
    private IASTNode fClassNode;
    private String fClassName;
    private ICPPClassType fClassBinding;
    private String fElementName;

    public VirtualMethodsASTVisitor(ITextSelection textSelection, String fileName, VirtualMethodContainer methodContainer, String elName) {
        this.shouldVisitDeclSpecifiers = true;
        this.fClassNode = null;
        this.fSelection = textSelection;
        this.fFileName = fileName;
        this.fMethodContainer = methodContainer;
        this.fElementName = elName;
    }

    public VirtualMethodContainer getVirtualMethodContainer() {
        return this.fMethodContainer;
    }

    public IASTNode getClassNode() {
        return this.fClassNode;
    }

    public String getClassName() {
        return this.fClassName;
    }

    public ICPPClassType getClassBinding() {
        return this.fClassBinding;
    }

    private boolean isInsideSelection(ICPPASTCompositeTypeSpecifier node) {
        IASTFileLocation location = node.getFileLocation();
        if (location == null) {
            return false;
        }
        if (this.fSelection == null) {
            IBinding binding = node.getName().resolveBinding();
            if (!(binding instanceof ICPPBinding)) {
                return false;
            }
            try {
                String elName = String.join((CharSequence)"::", ((ICPPBinding)binding).getQualifiedName());
                if (elName.equals(this.fElementName)) {
                    return true;
                }
            }
            catch (DOMException e) {
                CUIPlugin.log(e);
            }
            return false;
        }
        return location.getNodeOffset() <= this.fSelection.getOffset() && this.fSelection.getOffset() <= location.getNodeOffset() + location.getNodeLength() && location.getFileName().contains(this.fFileName);
    }

    public void visitAst(IASTTranslationUnit ast) {
        ast.accept((ASTVisitor)this);
        if (this.fClassNode != null) {
            MethodCollector methodCollector = new MethodCollector();
            methodCollector.fillContainer(this.fMethodContainer, this.fClassBinding, (IASTDeclSpecifier)this.fClassNode);
        }
    }

    public int visit(IASTDeclSpecifier declSpecifier) {
        if (declSpecifier instanceof ICPPASTCompositeTypeSpecifier && this.isInsideSelection((ICPPASTCompositeTypeSpecifier)declSpecifier)) {
            ICPPClassType classType;
            this.fClassNode = declSpecifier;
            ICPPASTCompositeTypeSpecifier typeSpec = (ICPPASTCompositeTypeSpecifier)declSpecifier;
            IBinding binding = typeSpec.getName().getBinding();
            if (!(binding instanceof ICPPClassType)) {
                this.fClassNode = null;
                return 3;
            }
            this.fClassName = binding.getName();
            this.fClassBinding = classType = (ICPPClassType)binding;
        }
        return 3;
    }
}

