/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.IRelayResponse;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.NextIndexReturnCode;

public class IndexResponse
implements IRelayResponse {
    public static final int SIZE = 64;
    private final long fOffset;
    private final long fPacketSize;
    private final long fContentSize;
    private final long fTimestampBegin;
    private final long fTimestampEnd;
    private final long fEventsDiscarded;
    private final long fStreamId;
    private final NextIndexReturnCode fStatus;
    private final int fFlags;

    public IndexResponse(DataInputStream inNet) throws IOException {
        byte[] data = new byte[64];
        inNet.readFully(data);
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.order(ByteOrder.BIG_ENDIAN);
        this.fOffset = bb.getLong();
        this.fPacketSize = bb.getLong();
        this.fContentSize = bb.getLong();
        this.fTimestampBegin = bb.getLong();
        this.fTimestampEnd = bb.getLong();
        this.fEventsDiscarded = bb.getLong();
        this.fStreamId = bb.getLong();
        this.fStatus = NextIndexReturnCode.values()[bb.getInt() - 1];
        this.fFlags = bb.getInt();
    }

    public long getOffset() {
        return this.fOffset;
    }

    public long getPacketSize() {
        return this.fPacketSize;
    }

    public long getContentSize() {
        return this.fContentSize;
    }

    public long getTimestampBegin() {
        return this.fTimestampBegin;
    }

    public long getTimestampEnd() {
        return this.fTimestampEnd;
    }

    public long getEventsDiscarded() {
        return this.fEventsDiscarded;
    }

    public long getStreamId() {
        return this.fStreamId;
    }

    public NextIndexReturnCode getStatus() {
        return this.fStatus;
    }

    public int getFlags() {
        return this.fFlags;
    }
}

