/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.internal.core.resources;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.php.composer.api.ComposerPackage;
import org.eclipse.php.composer.api.collection.ComposerPackages;
import org.eclipse.php.composer.api.collection.Psr;
import org.eclipse.php.composer.api.objects.Autoload;
import org.eclipse.php.composer.api.objects.Namespace;
import org.eclipse.php.composer.core.log.Logger;
import org.eclipse.php.composer.core.resources.IComposerProject;

public class ComposerProject
implements IComposerProject {
    private IProject project;
    private IScriptProject scriptProject;
    private ComposerPackage composer = null;
    private IFile json = null;
    private String vendorDir = null;
    private IPath vendorPath = null;

    public ComposerProject(IProject project) {
        this.project = project;
        IFile file = project.getFile("composer.json");
        if (file != null && file.exists()) {
            this.composer = new ComposerPackage();
            try {
                this.composer.fromJson(file.getLocation().toFile());
            }
            catch (Exception exception) {}
        }
    }

    public ComposerProject(IScriptProject project) {
        this(project.getProject());
        this.scriptProject = project;
    }

    @Override
    public IPath getFullPath() {
        return this.project.getFullPath();
    }

    @Override
    public String getVendorDir() {
        if (this.vendorDir == null) {
            if (this.composer != null && this.composer.getConfig() != null) {
                this.vendorDir = this.composer.getConfig().getVendorDir();
            }
            if (this.vendorDir == null || this.vendorDir.trim().isEmpty()) {
                this.vendorDir = "vendor";
            }
        }
        return this.vendorDir;
    }

    @Override
    public IPath getVendorPath() {
        if (this.vendorPath == null) {
            IPath root = this.project.getLocation();
            String vendor = this.getVendorDir();
            if (root == null || root.segmentCount() <= 1) {
                throw new RuntimeException("Error getting composer vendor path");
            }
            this.vendorPath = root.removeLastSegments(1).addTrailingSeparator().append(vendor);
        }
        return this.vendorPath;
    }

    @Override
    public IFile getComposerJson() {
        if (this.json == null) {
            this.json = this.project.getFile("composer.json");
        }
        return this.json;
    }

    @Override
    public ComposerPackage getComposerPackage() {
        if (this.composer == null) {
            IFile json;
            block4: {
                try {
                    json = this.getComposerJson();
                    if (json != null) break block4;
                    return null;
                }
                catch (Exception exception) {}
            }
            this.composer = new ComposerPackage(json.getLocation().toFile());
        }
        return this.composer;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public IScriptProject getScriptProject() {
        if (this.scriptProject == null) {
            this.scriptProject = DLTKCore.create((IProject)this.project);
        }
        return this.scriptProject;
    }

    @Override
    public ComposerPackages getInstalledPackages() {
        String vendor = this.getVendorDir();
        ComposerPackages packages = new ComposerPackages();
        IFile installed = this.project.getFile(vendor + "/composer/installed.json");
        if (installed != null && installed.exists()) {
            packages.addAll(this.loadInstalled(installed));
        }
        return packages;
    }

    @Override
    public boolean isValidComposerJson() {
        IFile json = this.getComposerJson();
        if (json != null && json.exists()) {
            try {
                new ComposerPackage(json.getLocation().toFile());
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    protected ComposerPackages loadInstalled(IFile installed) {
        try {
            if (installed.getLocation() != null) {
                return new ComposerPackages(installed.getLocation().toFile());
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return new ComposerPackages();
    }

    @Override
    public String getNamespace(IPath path) {
        Autoload autoload;
        String namespace;
        if (path.isAbsolute()) {
            path = path.removeFirstSegments(1).makeRelative();
        }
        if ((namespace = this.getPsrNamespace(path, (autoload = this.getComposerPackage().getAutoload()).getPsr4())) == null) {
            namespace = this.getPsrNamespace(path, autoload.getPsr0());
        }
        if (namespace == null && (namespace = this.getPsrNamespace(path, (autoload = this.getComposerPackage().getAutoloadDev()).getPsr4())) == null) {
            namespace = this.getPsrNamespace(path, autoload.getPsr0());
        }
        return namespace;
    }

    private String getPsrNamespace(IPath path, Psr psr) {
        Path appendix = new Path("");
        while (!path.isEmpty() && !path.isRoot()) {
            Namespace namespace = psr.getNamespaceForPath(path.addTrailingSeparator().toString());
            if (namespace == null) {
                namespace = psr.getNamespaceForPath(path.removeTrailingSeparator().toString());
            }
            if (namespace != null) {
                Object nmspc = namespace.getNamespace();
                Path nmspcPath = new Path(((String)nmspc).replace("\\", "/"));
                int match = nmspcPath.matchingFirstSegments((IPath)appendix);
                if ((appendix = appendix.removeFirstSegments(match)).segmentCount() > 0) {
                    nmspc = (String)nmspc + (!((String)nmspc).isEmpty() ? "\\" : "") + appendix.removeTrailingSeparator().toString().replace("/", "\\");
                }
                if (((String)(nmspc = ((String)nmspc).replace("\\\\", "\\"))).endsWith("\\")) {
                    nmspc = ((String)nmspc).substring(0, ((String)nmspc).length() - 1);
                }
                return nmspc;
            }
            appendix = new Path(path.lastSegment() + "/" + appendix.toString());
            path = path.removeLastSegments(1);
        }
        return null;
    }

    @Override
    public IPath getNamespaceDir(IPath source, String namespace) {
        Autoload[] autoloads = new Autoload[]{this.getComposerPackage().getAutoload(), this.getComposerPackage().getAutoloadDev()};
        Namespace matched = null;
        Autoload[] autoloadArray = autoloads;
        int n = autoloads.length;
        int n2 = 0;
        while (n2 < n) {
            Autoload autoload = autoloadArray[n2];
            for (Namespace name : autoload.getPsr4().getNamespaces()) {
                matched = this.match(namespace, name, matched);
            }
            for (Namespace name : autoload.getPsr0().getNamespaces()) {
                matched = this.match(namespace, name, matched);
            }
            ++n2;
        }
        if (matched != null) {
            String addon;
            String path = matched.getPaths().get(0).toString();
            IPath result = new Path(source.segment(0)).makeAbsolute();
            int move = matched.getNamespace().length();
            if (matched.getNamespace().endsWith("\\")) {
                --move;
            }
            if ((addon = namespace.substring(move)).endsWith("\\")) {
                addon = addon.substring(0, addon.length() - 1);
            }
            result = result.append((IPath)new Path(path));
            result = result.append((IPath)new Path(addon.replace('\\', '/')));
            return result;
        }
        return null;
    }

    private Namespace match(String namespace, Namespace current, Namespace previous) {
        if (!((String)(namespace = (String)namespace + "\\")).startsWith(current.getNamespace())) {
            return previous;
        }
        if (previous == null) {
            return current;
        }
        if (previous.getNamespace().length() > current.getNamespace().length()) {
            return previous;
        }
        return current;
    }
}

