/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiPlugin;
import org.eclipse.mylyn.internal.builds.ui.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class BuildsPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final long MILLIS_PER_MINUTE = 60000L;
    private Text intervalText;
    private Button enableRefreshButton;
    private Label intervalLabel;
    private Button refreshOnFocusButton;

    public IPreferenceStore getPreferenceStore() {
        return BuildsUiPlugin.getDefault().getPreferenceStore();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.enableRefreshButton = new Button(composite, 32);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.enableRefreshButton);
        this.enableRefreshButton.setText(Messages.BuildsPreferencesPage_automaticallyRefreshBuilds);
        this.enableRefreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildsPreferencesPage.this.updateEnablement();
            }
        });
        this.intervalLabel = new Label(composite, 0);
        this.intervalLabel.setText(Messages.BuildsPreferencesPage_refreshBuildStatusEveryInMinutes);
        this.intervalText = new Text(composite, 133120);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.intervalText);
        this.intervalText.setTextLimit(3);
        this.refreshOnFocusButton = new Button(composite, 32);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.refreshOnFocusButton);
        this.refreshOnFocusButton.setText(Messages.BuildsPreferencesPage_refreshWhenBuildsViewIsFocused);
        this.reset();
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void updateEnablement() {
        this.intervalLabel.setEnabled(this.enableRefreshButton.getSelection());
        this.intervalText.setEnabled(this.enableRefreshButton.getSelection());
    }

    public void init(IWorkbench workbench) {
    }

    public void reset() {
        this.intervalText.setText(String.valueOf(this.getPreferenceStore().getLong("refresh.interval") / 60000L));
        this.enableRefreshButton.setSelection(this.getPreferenceStore().getBoolean("refresh.enabled"));
        this.refreshOnFocusButton.setSelection(this.getPreferenceStore().getBoolean("refresh.onfocus"));
        this.updateEnablement();
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("refresh.enabled", this.enableRefreshButton.getSelection());
        this.getPreferenceStore().setValue("refresh.interval", this.getRefreshInterval());
        this.getPreferenceStore().setValue("refresh.onfocus", this.refreshOnFocusButton.getSelection());
        return super.performOk();
    }

    private long getRefreshInterval() {
        try {
            return Math.max((long)Integer.parseInt(this.intervalText.getText()) * 60000L, 60000L);
        }
        catch (NumberFormatException numberFormatException) {
            return 900000L;
        }
    }

    protected void performDefaults() {
        this.intervalText.setText(String.valueOf(this.getPreferenceStore().getDefaultLong("refresh.interval") / 60000L));
        this.enableRefreshButton.setSelection(this.getPreferenceStore().getDefaultBoolean("refresh.enabled"));
        this.refreshOnFocusButton.setSelection(this.getPreferenceStore().getDefaultBoolean("refresh.onfocus"));
        this.updateEnablement();
    }
}

