/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.publishing;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

public final class Utils {
    public static void copy(File source, File destination) throws IOException {
        Files.copy(source.toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static boolean guessUnpack(BundleDescription bundle, List<String> classpath) {
        if (bundle == null) {
            return true;
        }
        Dictionary properties = (Dictionary)bundle.getUserObject();
        String shape = null;
        if (properties != null && (shape = (String)properties.get("Eclipse-BundleShape")) != null) {
            return shape.equals("dir");
        }
        if (bundle.getHost() != null && bundle.getName().startsWith("org.eclipse.equinox.launcher")) {
            return true;
        }
        if (new File(bundle.getLocation()).isFile()) {
            return false;
        }
        if (!classpath.isEmpty()) {
            if (classpath.stream().noneMatch("."::equals)) {
                return true;
            }
        }
        return false;
    }

    public static List<String> getBundleClasspath(Dictionary<String, String> manifest) {
        String fullClasspath = Utils.getBundleManifestHeader(manifest, "Bundle-ClassPath");
        try {
            if (fullClasspath != null) {
                return Arrays.stream(ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)fullClasspath)).map(ManifestElement::getValue).toList();
            }
        }
        catch (BundleException bundleException) {
            // empty catch block
        }
        return List.of();
    }

    public static String getBundleManifestHeader(Dictionary<String, String> manifest, String header) {
        if (manifest == null) {
            return null;
        }
        String value = manifest.get(header);
        if (value != null) {
            return value;
        }
        Enumeration<String> keys = manifest.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!key.equalsIgnoreCase(header)) continue;
            return manifest.get(key);
        }
        return null;
    }
}

