/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.ISourceLookup;
import org.eclipse.cdt.dsf.debug.service.command.CommandCache;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.launching.GdbSourceLookupDirector;
import org.eclipse.cdt.dsf.gdb.service.IDebugSourceFiles;
import org.eclipse.cdt.dsf.gdb.service.IGDBSourceLookup;
import org.eclipse.cdt.dsf.mi.service.CSourceLookup;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.MiSourceFilesInfo;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class GDBSourceLookup
extends CSourceLookup
implements IGDBSourceLookup,
IDebugSourceFiles,
ICachingService {
    private ICommandControlService fCommand;
    private CommandFactory fCommandFactory;
    private Map<ISourceLookup.ISourceLookupDMContext, CSourceLookupDirector> fDirectors = new HashMap<ISourceLookup.ISourceLookupDMContext, CSourceLookupDirector>();
    private Map<String, String> fCachedEntries = Collections.emptyMap();
    private CommandCache fDebugSourceFilesCache;

    public GDBSourceLookup(DsfSession session) {
        super(session);
    }

    @Override
    public void initialize(final RequestMonitor rm) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(rm){

            protected void handleSuccess() {
                GDBSourceLookup.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        this.fCommand = (ICommandControlService)this.getServicesTracker().getService(ICommandControlService.class);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        this.fDebugSourceFilesCache = new CommandCache(this.getSession(), (ICommandControl)this.fCommand);
        this.fDebugSourceFilesCache.setContextAvailable((IDMContext)this.fCommand.getContext(), true);
        this.register(new String[]{IGDBSourceLookup.class.getName(), GDBSourceLookup.class.getName(), IDebugSourceFiles.class.getName()}, new Hashtable());
        rm.done();
    }

    @Override
    public void shutdown(RequestMonitor rm) {
        this.unregister();
        super.shutdown(rm);
    }

    @Override
    public void setSourceLookupDirector(ISourceLookup.ISourceLookupDMContext ctx, CSourceLookupDirector director) {
        this.fDirectors.put(ctx, director);
        super.setSourceLookupDirector(ctx, director);
    }

    @Override
    public void initializeSourceSubstitutions(ISourceLookup.ISourceLookupDMContext sourceLookupCtx, RequestMonitor rm) {
        if (!this.fDirectors.containsKey(sourceLookupCtx)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "No source director configured for given context", null));
            rm.done();
            return;
        }
        this.setSubstitutePaths(sourceLookupCtx, this.getSubstitutionsPaths(sourceLookupCtx), rm);
    }

    private Map<String, String> getSubstitutionsPaths(ISourceLookup.ISourceLookupDMContext sourceLookupCtx) {
        CSourceLookupDirector director = this.fDirectors.get(sourceLookupCtx);
        if (director instanceof GdbSourceLookupDirector) {
            return ((GdbSourceLookupDirector)director).getSubstitutionsPaths();
        }
        return Collections.emptyMap();
    }

    @Override
    public void sourceContainersChanged(ISourceLookup.ISourceLookupDMContext sourceLookupCtx, DataRequestMonitor<Boolean> rm) {
        if (!this.fDirectors.containsKey(sourceLookupCtx)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "No source director configured for given context", null));
            rm.done();
            return;
        }
        Map<String, String> entries = this.getSubstitutionsPaths(sourceLookupCtx);
        if (entries.equals(this.fCachedEntries)) {
            rm.done((Object)false);
        } else {
            CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)this.getExecutor(), (RequestMonitor)rm, (DataRequestMonitor)rm){
                private final /* synthetic */ DataRequestMonitor val$rm;
                {
                    this.val$rm = dataRequestMonitor;
                    super($anonymous0, $anonymous1);
                }

                protected void handleSuccess() {
                    this.val$rm.done((Object)true);
                }
            };
            this.fCommand.queueCommand(this.fCommandFactory.createCLIUnsetSubstitutePath(sourceLookupCtx), new DataRequestMonitor((Executor)this.getExecutor(), (RequestMonitor)countingRm));
            this.initializeSourceSubstitutions(sourceLookupCtx, new RequestMonitor((Executor)this.getExecutor(), (RequestMonitor)countingRm));
            countingRm.setDoneCount(2);
        }
    }

    protected void setSubstitutePaths(final ISourceLookup.ISourceLookupDMContext sourceLookupCtx, Map<String, String> entries, final RequestMonitor rm) {
        this.fCachedEntries = entries;
        CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleCompleted() {
                GDBSourceLookup.this.fDebugSourceFilesCache.reset();
                GDBSourceLookup.this.getSession().dispatchEvent((Object)new DebugSourceFilesChangedEvent((IDMContext)sourceLookupCtx), GDBSourceLookup.this.getProperties());
                if (!this.isSuccess()) {
                    GDBSourceLookup.this.fCachedEntries = null;
                }
                rm.done();
            }
        };
        countingRm.setDoneCount(entries.size());
        for (Map.Entry<String, String> entry : entries.entrySet()) {
            this.fCommand.queueCommand(this.fCommandFactory.createMISetSubstitutePath(sourceLookupCtx, entry.getKey(), entry.getValue()), new DataRequestMonitor((Executor)this.getExecutor(), (RequestMonitor)countingRm));
        }
    }

    @Override
    public void getSources(IDMContext dmc, final DataRequestMonitor<IDebugSourceFiles.IDebugSourceFileInfo[]> rm) {
        this.fDebugSourceFilesCache.execute(this.fCommandFactory.createMiFileListExecSourceFiles(dmc), (DataRequestMonitor)new DataRequestMonitor<MiSourceFilesInfo>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                IDebugSourceFiles.IDebugSourceFileInfo[] result = null;
                MiSourceFilesInfo sourceFiles = (MiSourceFilesInfo)this.getData();
                MiSourceFilesInfo.SourceFileInfo[] info = sourceFiles.getSourceFiles();
                result = (IDebugSourceFiles.IDebugSourceFileInfo[])Arrays.asList(info).stream().map(sourceFileInfo -> new DebugSourceFileInfo((MiSourceFilesInfo.SourceFileInfo)sourceFileInfo)).toArray(IDebugSourceFiles.IDebugSourceFileInfo[]::new);
                rm.setData((Object)result);
                rm.done();
            }
        });
    }

    public void flushCache(IDMContext context) {
        this.fDebugSourceFilesCache.reset();
        this.getSession().dispatchEvent((Object)new DebugSourceFilesChangedEvent((IDMContext)this.fCommand.getContext()), this.getProperties());
    }

    private static final class DebugSourceFileInfo
    implements IDebugSourceFiles.IDebugSourceFileInfo {
        private final MiSourceFilesInfo.SourceFileInfo miInfo;

        private DebugSourceFileInfo(MiSourceFilesInfo.SourceFileInfo miInfo) {
            if (miInfo == null) {
                throw new IllegalArgumentException("The SourceFileInfo provided is null");
            }
            this.miInfo = miInfo;
        }

        @Override
        public String getName() {
            String name;
            String string = name = this.miInfo != null ? this.miInfo.getFile() : null;
            if (name == null) {
                return name;
            }
            try {
                Path p = Paths.get(name, new String[0]);
                name = p.getFileName() != null ? p.getFileName().toString() : "";
            }
            catch (InvalidPathException invalidPathException) {
                // empty catch block
            }
            return name;
        }

        @Override
        public String getPath() {
            String path;
            String string = path = this.miInfo != null ? this.miInfo.getFullName() : null;
            if (path == null) {
                return path;
            }
            try {
                Path p = Paths.get(path, new String[0]);
                path = p.toString();
            }
            catch (InvalidPathException invalidPathException) {
                // empty catch block
            }
            return path;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.miInfo == null ? 0 : this.miInfo.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DebugSourceFileInfo other = (DebugSourceFileInfo)obj;
            return !(this.miInfo == null ? other.miInfo != null : !this.miInfo.equals(other.miInfo));
        }

        public String toString() {
            return "DebugSourceFileInfo [miInfo=" + String.valueOf(this.miInfo) + "]";
        }
    }

    private static class DebugSourceFilesChangedEvent
    extends AbstractDMEvent<IDMContext>
    implements IDebugSourceFiles.IDebugSourceFilesChangedEvent {
        public DebugSourceFilesChangedEvent(IDMContext context) {
            super(context);
        }
    }
}

