/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.provisional.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.internal.provisional.model.IMemoryBlockRetrievalManager;
import org.eclipse.cdt.dsf.debug.model.DsfMemoryBlockRetrieval;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.internal.DsfPlugin;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IMemoryBlockManager;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;

public class MemoryBlockRetrievalManager
implements IMemoryBlockRetrievalManager {
    private final String fModelId;
    private final DsfSession fSession;
    private final ILaunchConfiguration fLaunchConfig;
    private final Map<IMemory.IMemoryDMContext, IMemoryBlockRetrieval> fMapMemDMCToBlockRetrieval = new HashMap<IMemory.IMemoryDMContext, IMemoryBlockRetrieval>();

    public MemoryBlockRetrievalManager(String modelId, ILaunchConfiguration config, DsfSession session) {
        this.fModelId = modelId;
        this.fSession = session;
        this.fLaunchConfig = config;
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IStartedDMEvent event) {
        IMemory.IMemoryDMContext memDmc;
        if (event.getDMContext() instanceof IMemory.IMemoryDMContext && !this.fMapMemDMCToBlockRetrieval.containsKey(memDmc = (IMemory.IMemoryDMContext)event.getDMContext())) {
            IMemoryBlockRetrieval memRetrieval = null;
            try {
                memRetrieval = this.createMemoryBlockRetrieval(this.fModelId, this.fLaunchConfig, this.fSession);
            }
            catch (DebugException e) {
                DsfPlugin.getDefault().getLog().log(e.getStatus());
                return;
            }
            if (memRetrieval != null) {
                if (memRetrieval instanceof DsfMemoryBlockRetrieval) {
                    ((DsfMemoryBlockRetrieval)memRetrieval).initialize(memDmc);
                }
                this.fMapMemDMCToBlockRetrieval.put(memDmc, memRetrieval);
            }
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IExitedDMEvent event) {
        IMemory.IMemoryDMContext memDmc;
        IMemoryBlockRetrieval retrieval;
        if (event.getDMContext() instanceof IMemory.IMemoryDMContext && (retrieval = this.fMapMemDMCToBlockRetrieval.remove(memDmc = (IMemory.IMemoryDMContext)event.getDMContext())) != null) {
            if (retrieval instanceof DsfMemoryBlockRetrieval) {
                ((DsfMemoryBlockRetrieval)retrieval).saveMemoryBlocks();
            }
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)retrieval, 8)});
            Job removeJob = new Job("Removing memory blocks"){

                protected IStatus run(IProgressMonitor monitor) {
                    IMemoryBlockManager mbm = DebugPlugin.getDefault().getMemoryBlockManager();
                    IMemoryBlock[] deletedMemoryBlocks = mbm.getMemoryBlocks(retrieval);
                    mbm.removeMemoryBlocks(deletedMemoryBlocks);
                    return Status.OK_STATUS;
                }
            };
            removeJob.schedule();
        }
    }

    @Override
    public IMemoryBlockRetrieval getMemoryBlockRetrieval(IDMContext dmc) {
        IMemoryBlockRetrieval memRetrieval = null;
        IMemory.IMemoryDMContext memDmc = DMContexts.getAncestorOfType(dmc, IMemory.IMemoryDMContext.class);
        if (memDmc != null) {
            memRetrieval = this.fMapMemDMCToBlockRetrieval.get(memDmc);
        }
        return memRetrieval;
    }

    protected IMemoryBlockRetrieval createMemoryBlockRetrieval(String model, ILaunchConfiguration config, DsfSession session) throws DebugException {
        return new DsfMemoryBlockRetrieval(model, config, session);
    }

    @Override
    public void dispose() {
        this.fMapMemDMCToBlockRetrieval.clear();
    }
}

