/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.view.ui.internal.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.terminal.view.ui.internal.Messages;
import org.eclipse.terminal.view.ui.internal.UIPlugin;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public abstract class AbstractTriggerCommandHandler
extends AbstractHandler {
    protected void triggerCommand(String commandId, ISelection selection) {
        block4: {
            Command command;
            Assert.isNotNull((Object)commandId);
            ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command command2 = command = service != null ? service.getCommand(commandId) : null;
            if (command != null && command.isDefined() && command.isEnabled()) {
                try {
                    ParameterizedCommand pCmd = ParameterizedCommand.generateCommand((Command)command, null);
                    Assert.isNotNull((Object)pCmd);
                    IHandlerService handlerSvc = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                    Assert.isNotNull((Object)handlerSvc);
                    IEvaluationContext ctx = handlerSvc.getCurrentState();
                    if (selection != null) {
                        ctx = new EvaluationContext(ctx, (Object)selection);
                        ctx.addVariable("selection", (Object)selection);
                    }
                    handlerSvc.executeCommandInContext(pCmd, null, ctx);
                }
                catch (Exception e) {
                    if (!Platform.inDebugMode()) break block4;
                    Status status = new Status(4, UIPlugin.getUniqueIdentifier(), Messages.AbstractTriggerCommandHandler_error_executionFailed, (Throwable)e);
                    UIPlugin.getDefault().getLog().log((IStatus)status);
                }
            }
        }
    }
}

