/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.actions;

import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.wst.ws.internal.explorer.platform.actions.FormInputException;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.ListElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormToolPropertiesInterface;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.FindAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.QueryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.util.Validator;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.Name;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.response.BusinessInfo;
import org.uddi4j.response.BusinessInfos;
import org.uddi4j.response.RegisteredInfo;
import org.uddi4j.response.Result;
import org.uddi4j.response.ServiceInfo;
import org.uddi4j.response.ServiceInfos;
import org.uddi4j.transport.TransportException;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.FindQualifier;
import org.uddi4j.util.FindQualifiers;
import org.uddi4j.util.KeyedReference;
import org.uddi4j.util.TModelBag;

public class RegFindServicesAdvancedAction
extends FindAction {
    public RegFindServicesAdvancedAction(Controller controller) {
        super(controller);
        this.propertyTable_.put("queryItem", String.valueOf(1));
        this.propertyTable_.put("queryStyleServices", String.valueOf(1));
        this.propertyTable_.put("advancedServiceMaxSearchSet", String.valueOf(100));
        this.propertyTable_.put("advancedServiceMaxResults", String.valueOf(10));
    }

    @Override
    protected final boolean processOthers(MultipartFormDataParser parser, FormToolPropertiesInterface formToolPI) throws MultipartFormDataException {
        String ownedChecked = parser.getParameter("advancedOwned");
        String[] busNodeIds = parser.getParameterValues("nodeId_Business");
        String[] languages = parser.getParameterValues("advancedNameLanguage");
        String[] names = parser.getParameterValues("advancedName");
        String[] catTypes = parser.getParameterValues("advancedCategoryType");
        String[] catKeyNames = parser.getParameterValues("advancedCategoryKeyName");
        String[] catKeyValues = parser.getParameterValues("advancedCategoryKeyValue");
        String[] siNodeIds = parser.getParameterValues("nodeId_ServiceInterface");
        String[] findQualifierValues = parser.getParameterValues("advancedFindQualifier");
        String maxSearchSet = parser.getParameter("advancedMaxSearchSet");
        String maxResults = parser.getParameter("advancedMaxResults");
        boolean inputsValid = true;
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        this.regNode_.getTreeElement();
        if (ownedChecked != null) {
            this.propertyTable_.put("advancedServiceOwned", ownedChecked);
        } else {
            this.removeProperty("advancedServiceOwned");
        }
        if (busNodeIds != null) {
            Vector<ListElement> serviceBusiness = (Vector<ListElement>)formToolPI.getProperty("advancedServiceBusiness");
            if (serviceBusiness == null) {
                serviceBusiness = new Vector<ListElement>();
            } else {
                serviceBusiness.removeAllElements();
            }
            Vector serviceBusinessCopy = (Vector)formToolPI.getProperty("advancedServiceBusinessCopy");
            ListElement listElement = (ListElement)serviceBusinessCopy.elementAt(0);
            serviceBusiness.addElement(listElement);
            BusinessEntity sp = (BusinessEntity)listElement.getObject();
            this.propertyTable_.put("advancedServiceBusiness", serviceBusiness);
            this.propertyTable_.put("advancedServiceServiceProvider", sp);
        } else {
            this.removeProperty("advancedServiceBusiness");
            this.removeProperty("advancedServiceServiceProvider");
        }
        if (languages != null && names != null) {
            Vector<Name> nameVector = new Vector<Name>();
            int i = 0;
            while (i < names.length) {
                Name uddi4jName = languages[i].length() > 0 ? new Name(names[i], languages[i]) : new Name(names[i]);
                nameVector.addElement(uddi4jName);
                ++i;
            }
            this.propertyTable_.put("advancedServiceNames", nameVector);
        } else {
            this.removeProperty("advancedServiceNames");
        }
        if (catTypes != null && catKeyNames != null && catKeyValues != null) {
            CategoryBag catBag = new CategoryBag();
            int i = 0;
            while (i < catTypes.length) {
                KeyedReference kr = new KeyedReference(catKeyNames[i], catKeyValues[i], catTypes[i]);
                catBag.add(kr);
                ++i;
            }
            this.propertyTable_.put("advancedServiceCategories", catBag);
        } else {
            this.removeProperty("advancedServiceCategories");
        }
        if (siNodeIds != null) {
            Vector<ListElement> serviceServiceInterfaces = (Vector<ListElement>)formToolPI.getProperty("advancedServiceServiceInterfaces");
            if (serviceServiceInterfaces == null) {
                serviceServiceInterfaces = new Vector<ListElement>();
            } else {
                serviceServiceInterfaces.removeAllElements();
            }
            Vector serviceServiceInterfacesCopy = (Vector)formToolPI.getProperty("advancedServiceServiceInterfacesCopy");
            Vector<String> tModelKeyStringVector = new Vector<String>();
            Hashtable<String, Boolean> resultHash = new Hashtable<String, Boolean>();
            int i = 0;
            while (i < siNodeIds.length) {
                resultHash.put(siNodeIds[i], Boolean.TRUE);
                ++i;
            }
            i = 0;
            while (i < serviceServiceInterfacesCopy.size()) {
                ListElement listElement = (ListElement)serviceServiceInterfacesCopy.elementAt(i);
                if (resultHash.get(String.valueOf(listElement.getTargetNodeId())) != null) {
                    serviceServiceInterfaces.addElement(listElement);
                    TModel tModel = (TModel)listElement.getObject();
                    tModelKeyStringVector.addElement(tModel.getTModelKey());
                }
                ++i;
            }
            TModelBag tModelBag = new TModelBag(tModelKeyStringVector);
            this.propertyTable_.put("advancedServiceServiceInterfaces", serviceServiceInterfaces);
            this.propertyTable_.put("advancedServiceTModelBag", tModelBag);
        } else {
            this.removeProperty("advancedServiceServiceInterfaces");
            this.removeProperty("advancedServiceTModelBag");
        }
        if (findQualifierValues != null) {
            FindQualifiers findQualifiers = new FindQualifiers();
            Vector<FindQualifier> findQualifierVector = new Vector<FindQualifier>();
            int i = 0;
            while (i < findQualifierValues.length) {
                FindQualifier findQualifier = new FindQualifier(findQualifierValues[i]);
                findQualifierVector.addElement(findQualifier);
                ++i;
            }
            findQualifiers.setFindQualifierVector(findQualifierVector);
            this.propertyTable_.put("advancedServiceFindQualifiers", findQualifiers);
        } else {
            this.removeProperty("advancedServiceFindQualifiers");
        }
        if (maxSearchSet != null) {
            this.propertyTable_.put("advancedMaxSearchSet", maxSearchSet);
            this.propertyTable_.put("advancedServiceMaxSearchSet", maxSearchSet);
        }
        if (!this.subQueryInitiated_ && !Validator.validateInteger(maxSearchSet)) {
            formToolPI.flagError("advancedServiceMaxSearchSet");
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_MAX_SEARCH_SET"));
            inputsValid = false;
        }
        if (maxResults != null) {
            this.propertyTable_.put("advancedMaxResults", maxResults);
            this.propertyTable_.put("advancedServiceMaxResults", maxResults);
        }
        if (!this.subQueryInitiated_ && !Validator.validateInteger(maxResults)) {
            formToolPI.flagError("advancedServiceMaxResults");
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_MAX_RESULTS"));
            inputsValid = false;
        }
        return inputsValid;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final boolean run() {
        block21: {
            uddiPerspective = this.controller_.getUDDIPerspective();
            messageQueue = uddiPerspective.getMessageQueue();
            shouldAddQueryNode = this.propertyTable_.get("overrideAddQueryNode") == null;
            findQualifiers = (FindQualifiers)this.propertyTable_.get("advancedServiceFindQualifiers");
            sp = (BusinessEntity)this.propertyTable_.get("advancedServiceServiceProvider");
            nameVector = (Vector)this.propertyTable_.get("advancedServiceNames");
            categoryBag = (CategoryBag)this.propertyTable_.get("advancedServiceCategories");
            tModelBag = (TModelBag)this.propertyTable_.get("advancedServiceTModelBag");
            owned = this.propertyTable_.get("advancedServiceOwned") != null;
            publishURL = (String)this.propertyTable_.get("advancedPublishURL");
            userId = (String)this.propertyTable_.get("advancedUserId");
            password = (String)this.propertyTable_.get("advancedPassword");
            maxSearchSet = Integer.parseInt((String)this.propertyTable_.get("advancedServiceMaxSearchSet"));
            maxResults = Integer.parseInt((String)this.propertyTable_.get("advancedServiceMaxResults"));
            regElement = (RegistryElement)this.regNode_.getTreeElement();
            if (owned && !regElement.isLoggedIn()) {
                regElement.performLogin(publishURL, userId, password);
            }
            proxy = regElement.getProxy();
            businessKey = sp != null ? sp.getBusinessKey() : "";
            if (owned) {
                serviceKeyVector = this.findAllOwnedServices(proxy, regElement.getAuthInfoString(), businessKey, maxResults);
                finalNumberOfServiceKeys = serviceKeyVector.size();
            } else {
                serviceList = proxy.find_service(businessKey, nameVector, categoryBag, tModelBag, findQualifiers, maxSearchSet);
                sInfos = serviceList.getServiceInfos();
                finalNumberOfServiceKeys = Math.min(maxResults, sInfos.size());
                serviceKeyVector = new Vector<String>();
                i = 0;
                while (i < finalNumberOfServiceKeys) {
                    sInfo = sInfos.get(i);
                    serviceKeyVector.addElement(sInfo.getServiceKey());
                    ++i;
                }
            }
            if (finalNumberOfServiceKeys <= 0) break block21;
            if (shouldAddQueryNode) {
                finalBusServiceVector = new Vector<E>();
                currentIndex = 0;
                windowSize = finalNumberOfServiceKeys;
                block10: while (currentIndex < serviceKeyVector.size()) {
                    block22: {
                        subListToIndex = Math.min(currentIndex + windowSize, serviceKeyVector.size());
                        try {
                            serviceDetail = proxy.get_serviceDetail(new Vector<E>(serviceKeyVector.subList(currentIndex, subListToIndex)));
                            busServiceVector = serviceDetail.getBusinessServiceVector();
                            i = 0;
                            while (i < busServiceVector.size()) {
                                finalBusServiceVector.addElement(busServiceVector.elementAt(i));
                                ++i;
                            }
                            if (serviceDetail.getTruncatedBoolean()) {
                                windowSize = busServiceVector.size();
                            }
                            currentIndex += windowSize;
                            continue;
                        }
                        catch (UDDIException e) {
                            dr = e.getDispositionReport();
                            if (((Result)dr.getResultVector().get(0)).getErrInfo().getErrCode() != "E_invalidKeyPassed") break block22;
                            errInfoText = ((Result)dr.getResultVector().get(0)).getErrInfo().getText();
                            i = currentIndex;
                            ** while (i < subListToIndex)
                        }
lbl-1000:
                        // 1 sources

                        {
                            serviceKey = (String)serviceKeyVector.elementAt(i);
                            if (errInfoText.indexOf(serviceKey) != -1 || errInfoText.indexOf(serviceKey.toUpperCase()) != -1 || errInfoText.indexOf(serviceKey.toLowerCase()) != -1) {
                                serviceKeyVector.removeElementAt(i);
                                continue block10;
                            }
                            ++i;
                            continue;
lbl66:
                            // 1 sources

                            continue block10;
                        }
                    }
                    throw e;
                    catch (TransportException e) {
                        throw e;
                    }
                }
                finalNumberOfBusinessServices = finalBusServiceVector.size();
                if (finalNumberOfBusinessServices > 0) {
                    bsArray = new BusinessService[finalNumberOfBusinessServices];
                    finalBusServiceVector.toArray(bsArray);
                    queryName = (String)this.propertyTable_.get("queryName");
                    this.queryElement_ = new QueryElement(bsArray, queryName, regElement.getModel());
                    this.addQueryNode();
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_INFO_SERVICES_FOUND", String.valueOf(bsArray.length)));
                } else {
                    throw new FormInputException(uddiPerspective.getMessage("MSG_ERROR_NO_SERVICES_FOUND"));
                }
            }
            return true;
        }
        try {
            throw new FormInputException(uddiPerspective.getMessage("MSG_ERROR_NO_SERVICES_FOUND"));
        }
        catch (UDDIException e) {
            messageQueue.addMessage(uddiPerspective.getController().getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("UDDIException");
            messageQueue.addMessage(e.toString());
        }
        catch (TransportException e) {
            this.handleUnexpectedException(uddiPerspective, messageQueue, "TransportException", e);
        }
        catch (FormInputException e) {
            messageQueue.addMessage(e.getMessage());
        }
        catch (MalformedURLException e) {
            this.handleUnexpectedException(uddiPerspective, messageQueue, "MalformedURLException", e);
        }
        return false;
    }

    private final Vector findAllOwnedServices(UDDIProxy proxy, String authInfoString, String businessKey, int maxResults) throws UDDIException, TransportException {
        RegisteredInfo registeredInfo = null;
        registeredInfo = proxy.get_registeredInfo(authInfoString);
        Vector<String> serviceKeyList = new Vector<String>();
        BusinessInfos businessInfos = registeredInfo.getBusinessInfos();
        boolean endSearch = false;
        int i = 0;
        while (i < businessInfos.size()) {
            BusinessInfo businessInfo = businessInfos.get(i);
            String currentBusinessKey = businessInfo.getBusinessKey();
            if (businessKey.length() > 0 && currentBusinessKey.equals(businessKey)) {
                endSearch = true;
            }
            ServiceInfos serviceInfos = businessInfo.getServiceInfos();
            int j = 0;
            while (j < serviceInfos.size()) {
                ServiceInfo serviceInfo = serviceInfos.get(j);
                if (serviceInfo.getBusinessKey().equals(currentBusinessKey)) {
                    if (serviceKeyList.size() < maxResults) {
                        serviceKeyList.add(serviceInfo.getServiceKey());
                    } else {
                        endSearch = true;
                        break;
                    }
                }
                ++j;
            }
            if (endSearch) break;
            ++i;
        }
        return serviceKeyList;
    }
}

