/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.flatfile;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.flatfile.i18n.Messages;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataTypeMapping;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;

public final class DataTypes {
    static final int STRING = 12;
    static final int NULL = 0;
    static final String NULL_LITERAL = "NULL";
    private static final String FLATFILE_DATA_SOURCE_ID = "org.eclipse.datatools.connectivity.oda.flatfile";

    public static int getTypeCode(String typeName) throws OdaException {
        if (typeName == null || typeName.trim().length() == 0) {
            return 12;
        }
        String preparedTypeName = typeName.trim().toUpperCase();
        if (preparedTypeName.equals(NULL_LITERAL)) {
            return 0;
        }
        DataTypeMapping typeMapping = DataTypes.getManifest().getDataSetType(null).getDataTypeMapping(preparedTypeName);
        if (typeMapping != null) {
            return typeMapping.getNativeTypeCode();
        }
        throw new OdaException(String.valueOf(Messages.getString("dataTypes_TYPE_NAME_INVALID")) + typeName);
    }

    public static boolean isValidType(String typeName) {
        String preparedTypeName = typeName.trim().toUpperCase();
        if (preparedTypeName.equals(NULL_LITERAL)) {
            return true;
        }
        DataTypeMapping typeMapping = null;
        try {
            typeMapping = DataTypes.getManifest().getDataSetType(null).getDataTypeMapping(preparedTypeName);
        }
        catch (OdaException odaException) {}
        return typeMapping != null;
    }

    private DataTypes() {
    }

    static ExtensionManifest getManifest() throws OdaException {
        return ManifestExplorer.getInstance().getExtensionManifest(FLATFILE_DATA_SOURCE_ID);
    }
}

