/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.plan.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.datatools.sqltools.plan.PlanRequest;
import org.eclipse.datatools.sqltools.plan.internal.IPlanInstance;
import org.eclipse.datatools.sqltools.plan.internal.IPlanManager;
import org.eclipse.datatools.sqltools.plan.internal.IPlanManagerListener;
import org.eclipse.datatools.sqltools.plan.internal.core.PlanInstance;

public class PlanManager
implements IPlanManager {
    ListenerList<IPlanManagerListener> _listeners = new ListenerList();
    List _plans = new ArrayList();
    Map _map = new HashMap();

    @Override
    public void addPlanManagerListener(IPlanManagerListener listener) {
        this._listeners.add((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPlanInstance createNewPlanInstance(PlanRequest request) {
        PlanInstance instance = new PlanInstance(this, request);
        List list = this._plans;
        synchronized (list) {
            this._plans.add(instance);
            this._map.put(request, instance);
        }
        this.fireAdded(instance);
        return instance;
    }

    protected void fireAdded(IPlanInstance instance) {
        for (IPlanManagerListener listener : this._listeners) {
            listener.planInstanceCreated(instance);
        }
    }

    public void fireFinish(IPlanInstance instance) {
        for (IPlanManagerListener listener : this._listeners) {
            listener.planInstanceFinished(instance);
        }
    }

    protected void fireRemoved() {
        for (IPlanManagerListener listener : this._listeners) {
            listener.planInstancesRemoved();
        }
    }

    protected void fireRemoved(IPlanInstance instance) {
        for (IPlanManagerListener listener : this._listeners) {
            listener.planInstanceRemoved(instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPlanInstance[] getAllPlanInstances() {
        List list = this._plans;
        synchronized (list) {
            return this._plans.toArray(new IPlanInstance[this._plans.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllFinished() {
        boolean removed = false;
        List list = this._plans;
        synchronized (list) {
            Iterator iter = this._plans.iterator();
            while (iter.hasNext()) {
                IPlanInstance instance = (IPlanInstance)iter.next();
                if (!instance.isFinished()) continue;
                this._map.remove(instance.getPlanRequest());
                iter.remove();
                removed = true;
            }
        }
        if (removed) {
            this.fireRemoved();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePlanInstance(IPlanInstance instance) {
        boolean removed;
        List list = this._plans;
        synchronized (list) {
            removed = this._plans.remove(instance);
            this._map.remove(instance.getPlanRequest());
        }
        if (removed) {
            this.fireRemoved(instance);
        }
    }

    @Override
    public void removePlanManagerListener(IPlanManagerListener listener) {
        this._listeners.remove((Object)listener);
    }

    @Override
    public IPlanInstance getPlanInstance(PlanRequest request) {
        return (IPlanInstance)this._map.get(request);
    }
}

