/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.explorer.resources;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.refresh.IRefreshMonitor;
import org.eclipse.core.resources.refresh.IRefreshResult;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewInvalidationEvent;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;

public class CDOCheckoutRefreshMonitor
implements IRefreshMonitor,
IListener {
    private final Set<IResource> resources = new HashSet<IResource>();
    private final IRefreshResult workspace;
    private final String checkoutID;
    private CDOCheckout checkout;

    public CDOCheckoutRefreshMonitor(String checkoutID, IRefreshResult workspace) {
        this.workspace = workspace;
        this.checkoutID = checkoutID;
    }

    public CDOCheckout getCheckout() {
        return this.checkout;
    }

    public void setCheckout(CDOCheckout checkout) {
        CDOCheckout oldCheckout = this.checkout;
        this.checkout = checkout;
        if (checkout != null) {
            if (oldCheckout == null) {
                this.checkoutAdded(checkout);
            }
        } else if (oldCheckout != null) {
            this.checkoutRemoved(oldCheckout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIdle() {
        Set<IResource> set = this.resources;
        synchronized (set) {
            return this.resources.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitor(IResource resource) {
        CDOCheckout checkout;
        Set<IResource> set = this.resources;
        synchronized (set) {
            this.resources.add(resource);
        }
        if (this.checkout == null && (checkout = CDOExplorerUtil.getCheckoutManager().getCheckout(this.checkoutID)) != null) {
            this.checkout = checkout;
            this.checkoutAdded(checkout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unmonitor(IResource resource) {
        Set<IResource> set = this.resources;
        synchronized (set) {
            if (resource == null) {
                this.resources.clear();
            } else {
                this.resources.remove(resource);
            }
        }
    }

    public void notifyEvent(IEvent event) {
        if (event instanceof CDOViewInvalidationEvent) {
            this.refreshResources();
        }
    }

    private void checkoutAdded(CDOCheckout checkout) {
        this.refreshResources();
        CDOView view = checkout.getView();
        if (view != null) {
            view.addListener((IListener)this);
        }
    }

    private void checkoutRemoved(CDOCheckout checkout) {
        CDOView view = checkout.getView();
        if (view != null) {
            view.removeListener((IListener)this);
        }
        this.refreshResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshResources() {
        Set<IResource> set = this.resources;
        synchronized (set) {
            for (IResource resource : this.resources) {
                this.workspace.refresh(resource);
            }
        }
    }
}

