/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.wizards.ResizableWizardDialog;
import org.eclipse.pde.internal.ui.wizards.exports.ProductExportWizard;
import org.eclipse.ui.PlatformUI;

public class ProductExportAction
extends Action {
    private final IProject fProject;
    private final IStructuredSelection fSelection;

    public ProductExportAction(PDEFormEditor editor) {
        IResource resource = null;
        if (editor != null) {
            IModel model = (IModel)editor.getAggregateModel();
            resource = model == null ? null : model.getUnderlyingResource();
        }
        this.fSelection = resource != null ? new StructuredSelection(resource) : new StructuredSelection();
        this.fProject = editor.getCommonProject();
    }

    public ProductExportAction(IStructuredSelection selection) {
        this.fSelection = selection;
        this.fProject = null;
    }

    public void run() {
        ProductExportWizard wizard = new ProductExportWizard(this.fProject);
        wizard.init(PlatformUI.getWorkbench(), this.fSelection);
        ResizableWizardDialog wd = new ResizableWizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
        wd.create();
        this.notifyResult(wd.open() == 0);
    }
}

