/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.wizard;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.php.composer.ui.wizard.LocationGroup;
import org.eclipse.php.internal.ui.wizards.NameGroup;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class DetectGroup
extends Observable
implements Observer,
SelectionListener {
    private final Link fHintText;
    private Label fIcon;
    private boolean fDetect;
    private LocationGroup fPHPLocationGroup;
    private NameGroup fGroupName;

    public DetectGroup(Composite parent, LocationGroup locationGroup, NameGroup nameGroup) {
        this.fPHPLocationGroup = locationGroup;
        this.fGroupName = nameGroup;
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 128, true, true));
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.fIcon = new Label(composite, 16384);
        this.fIcon.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
        GridData gridData = new GridData(16384, 0x1000000, false, false);
        this.fIcon.setLayoutData((Object)gridData);
        this.fIcon.setVisible(false);
        this.fHintText = new Link(composite, 64);
        this.fHintText.setFont(composite.getFont());
        gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 500;
        this.fHintText.setLayoutData((Object)gridData);
        this.fHintText.setText(NewWizardMessages.ScriptProjectWizardFirstPage_DetectGroup_message);
        this.fHintText.setVisible(false);
    }

    private boolean isValidProjectName(String name) {
        if (name.length() == 0) {
            return false;
        }
        IWorkspace workspace = DLTKUIPlugin.getWorkspace();
        return workspace.validateName(name, 4).isOK() && workspace.getRoot().findMember(name) == null;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof LocationGroup) {
            boolean oldDetectState = this.fDetect;
            IPath location = this.fPHPLocationGroup.getLocation();
            if (this.fPHPLocationGroup.isInWorkspace()) {
                if (!this.isValidProjectName(this.fGroupName.getName())) {
                    this.fDetect = false;
                } else {
                    IEnvironment environment = this.fPHPLocationGroup.getEnvironment();
                    IFileHandle directory = environment.getFile(location.append(this.fGroupName.getName()));
                    this.fDetect = directory.isDirectory();
                }
            } else {
                IEnvironment environment = this.fPHPLocationGroup.getEnvironment();
                if (location.toPortableString().length() > 0) {
                    IFileHandle directory = environment.getFile(location);
                    boolean bl = this.fDetect = directory.isDirectory() && directory.getPath().toFile().exists();
                }
            }
            if (oldDetectState != this.fDetect) {
                this.setChanged();
                this.notifyObservers();
                if (this.fDetect) {
                    this.fHintText.setVisible(true);
                    this.fIcon.setVisible(true);
                } else {
                    this.fHintText.setVisible(false);
                    this.fIcon.setVisible(false);
                }
            }
        }
    }

    public boolean mustDetect() {
        return this.fDetect;
    }

    public void widgetSelected(SelectionEvent e) {
        this.widgetDefaultSelected(e);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (DLTKCore.DEBUG) {
            System.err.println("DetectGroup show compilancePreferencePage...");
        }
    }
}

