/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.rewrite;

import java.io.IOException;
import java_cup.runtime.Symbol;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.ast.scanner.AstLexer;
import org.eclipse.php.internal.core.ast.util.RandomAccessCharArrayReader;

public class TokenScanner {
    public static final int END_OF_FILE = 0;
    public static final int LEXICAL_ERROR = 20002;
    private static final String[] MODIFIERS = new String[]{"public", "private", "protected", "static", "abstract", "final"};
    private AstLexer scanner;
    private RandomAccessCharArrayReader charReader;
    private Symbol currentToken;
    private int offset;

    public TokenScanner(AstLexer scanner, char[] content) throws IOException {
        this.scanner = scanner;
        this.charReader = new RandomAccessCharArrayReader(content);
        this.scanner.yyreset(this.charReader);
        this.scanner.resetCommentList();
    }

    public AstLexer getScanner() {
        return this.scanner;
    }

    public void setOffset(int offset) {
        this.offset = offset;
        this.charReader.reset(offset);
        try {
            this.scanner.yyreset(this.charReader);
            this.scanner.setInScriptingState();
            this.scanner.resetCommentList();
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    public int getCurrentEndOffset() {
        if (this.currentToken != null) {
            return this.offset + this.currentToken.right;
        }
        return 0;
    }

    public int getCurrentStartOffset() {
        if (this.currentToken != null) {
            return this.offset + this.currentToken.left;
        }
        return 0;
    }

    public int getCurrentLength() {
        return this.getCurrentEndOffset() - this.getCurrentStartOffset();
    }

    public Symbol readNext() throws CoreException {
        this.currentToken = null;
        try {
            this.currentToken = this.scanner.next_token();
        }
        catch (Exception e) {
            throw new CoreException(TokenScanner.createError(20002, e.getMessage(), e));
        }
        if (this.currentToken.sym == 0) {
            throw new CoreException(TokenScanner.createError(0, "End Of File", null));
        }
        return this.currentToken;
    }

    public Symbol readNext(int offset) throws CoreException {
        this.setOffset(offset);
        return this.readNext();
    }

    public int getNextStartOffset(int offset) throws CoreException {
        this.readNext(offset);
        return this.getCurrentStartOffset();
    }

    public int getNextEndOffset(int offset) throws CoreException {
        this.readNext(offset);
        return this.getCurrentEndOffset();
    }

    public void readToToken(Symbol tok) throws CoreException {
        this.currentToken = null;
        do {
            this.currentToken = this.readNext();
        } while (this.currentToken != null && this.currentToken.sym != tok.sym);
    }

    public void readToToken(Symbol tok, int offset) throws CoreException {
        this.setOffset(offset);
        this.readToToken(tok);
    }

    public int getTokenStartOffset(Symbol token, int startOffset) throws CoreException {
        this.readToToken(token, startOffset);
        return this.getCurrentStartOffset();
    }

    public int getTokenEndOffset(Symbol token, int startOffset) throws CoreException {
        this.readToToken(token, startOffset);
        return this.getCurrentEndOffset();
    }

    public int getPreviousTokenEndOffset(Symbol token, int startOffset) throws CoreException {
        this.setOffset(startOffset);
        int res = startOffset;
        Symbol curr = this.readNext();
        while (curr != null && curr.sym != token.sym) {
            res = this.getCurrentEndOffset();
            curr = this.readNext();
        }
        return res;
    }

    public static boolean isComment(Symbol token) {
        return false;
    }

    public static boolean isModifier(Symbol token) {
        if (token == null || token.value == null) {
            return false;
        }
        String[] stringArray = MODIFIERS;
        int n = MODIFIERS.length;
        int n2 = 0;
        while (n2 < n) {
            String modifier = stringArray[n2];
            if (token.value.equals(modifier)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static IStatus createError(int code, String message, Throwable throwable) {
        return new Status(4, "org.eclipse.php.core", code, message, throwable);
    }
}

