/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.indexwizards;

import org.eclipse.cdt.internal.ui.wizards.indexwizards.Messages;
import org.eclipse.cdt.internal.ui.wizards.indexwizards.StringVariableLabelProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class StringVariableSelectionDialog
extends ElementListSelectionDialog {
    private Text fDescriptionText;
    private Text fArgumentText;
    private String fArgumentValue;

    public StringVariableSelectionDialog(Shell parent) {
        super(parent, (ILabelProvider)new StringVariableLabelProvider());
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle(Messages.StringVariableSelectionDialog_title);
        this.setMessage(Messages.StringVariableSelectionDialog_message);
        this.setMultipleSelection(false);
        this.setElements(VariablesPlugin.getDefault().getStringVariableManager().getVariables());
    }

    public String getVariableExpression() {
        Object[] selected = this.getResult();
        if (selected != null && selected.length == 1) {
            IStringVariable variable = (IStringVariable)selected[0];
            StringBuilder buffer = new StringBuilder();
            buffer.append("${");
            buffer.append(variable.getName());
            if (this.fArgumentValue != null && this.fArgumentValue.length() > 0) {
                buffer.append(":");
                buffer.append(this.fArgumentValue);
            }
            buffer.append("}");
            return buffer.toString();
        }
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        this.createArgumentArea((Composite)control);
        return control;
    }

    private void createArgumentArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        container.setLayoutData((Object)gd);
        container.setFont(parent.getFont());
        Label desc = new Label(container, 0);
        desc.setFont(parent.getFont());
        desc.setText(Messages.StringVariableSelectionDialog_columnArgument);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        desc.setLayoutData((Object)gd);
        Composite args = new Composite(container, 0);
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        args.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        args.setLayoutData((Object)gd);
        args.setFont(container.getFont());
        this.fArgumentText = new Text(args, 2048);
        this.fArgumentText.setFont(container.getFont());
        gd = new GridData(768);
        this.fArgumentText.setLayoutData((Object)gd);
        this.fArgumentText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.StringVariableSelectionDialog_columnArgument;
            }
        });
        desc = new Label(container, 0);
        desc.setFont(parent.getFont());
        desc.setText(Messages.StringVariableSelectionDialog_columnDescription);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        desc.setLayoutData((Object)gd);
        this.fDescriptionText = new Text(container, 2624);
        this.fDescriptionText.setFont(container.getFont());
        this.fDescriptionText.setEditable(false);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.heightHint = 50;
        this.fDescriptionText.setLayoutData((Object)gd);
    }

    protected void handleSelectionChanged() {
        super.handleSelectionChanged();
        Object[] objects = this.getSelectedElements();
        boolean argEnabled = false;
        String text = null;
        if (objects.length == 1) {
            IStringVariable variable = (IStringVariable)objects[0];
            if (variable instanceof IDynamicVariable) {
                argEnabled = ((IDynamicVariable)variable).supportsArgument();
            }
            text = variable.getDescription();
        }
        if (text == null) {
            text = "";
        }
        this.fArgumentText.setEnabled(argEnabled);
        this.fDescriptionText.setText(text);
    }

    protected void okPressed() {
        this.fArgumentValue = this.fArgumentText.getText().trim();
        super.okPressed();
    }

    private String getDialogSettingsSectionName() {
        return "org.eclipse.cdt.ui.STRING_VARIABLE_SELECTION_DIALOG_SECTION";
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = CUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        return section;
    }
}

