/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.WritePendingException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ConditionalHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadLimitHandler
extends ConditionalHandler.Abstract {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadLimitHandler.class);
    private final boolean _rfc7239;
    private final String _forwardedHeader;
    private final ConcurrentHashMap<String, Remote> _remotes = new ConcurrentHashMap();
    private volatile boolean _enabled;
    private int _threadLimit = 10;

    public ThreadLimitHandler() {
        this(null, null, true);
    }

    public ThreadLimitHandler(@Name(value="forwardedHeader") String forwardedHeader) {
        this(null, forwardedHeader, HttpHeader.FORWARDED.is(forwardedHeader));
    }

    public ThreadLimitHandler(@Name(value="forwardedHeader") String forwardedHeader, @Name(value="rfc7239") boolean rfc7239) {
        this(null, forwardedHeader, rfc7239);
    }

    public ThreadLimitHandler(@Name(value="handler") Handler handler, @Name(value="forwardedHeader") String forwardedHeader, @Name(value="rfc7239") boolean rfc7239) {
        super(handler);
        this._rfc7239 = rfc7239;
        this._forwardedHeader = forwardedHeader;
        this._enabled = true;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        LOG.info(String.format("ThreadLimitHandler enable=%b limit=%d", this._enabled, this._threadLimit));
    }

    @ManagedAttribute(value="Whether this handler is enabled")
    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
        LOG.info(String.format("ThreadLimitHandler enable=%b limit=%d", this._enabled, this._threadLimit));
    }

    @ManagedAttribute(value="The maximum threads that can be dispatched per remote IP")
    public int getThreadLimit() {
        return this._threadLimit;
    }

    protected int getThreadLimit(String ip) {
        return this._threadLimit;
    }

    public void setThreadLimit(int threadLimit) {
        if (threadLimit <= 0) {
            throw new IllegalArgumentException("limit must be >0");
        }
        this._threadLimit = threadLimit;
    }

    @ManagedOperation(value="Include IP in thread limits")
    public void include(String inetAddressPattern) {
        this.includeInetAddressPattern(inetAddressPattern);
    }

    @ManagedOperation(value="Exclude IP from thread limits")
    public void exclude(String inetAddressPattern) {
        this.excludeInetAddressPattern(inetAddressPattern);
    }

    @Override
    public boolean onConditionsMet(Request request, Response response, Callback callback) throws Exception {
        Handler next = this.getHandler();
        if (next == null) {
            return false;
        }
        if (!this._enabled) {
            return next.handle(request, response, callback);
        }
        Remote remote = this.getRemote(request);
        if (remote == null) {
            return next.handle(request, response, callback);
        }
        LimitedRequest limitedRequest = new LimitedRequest(remote, next, request, response, Callback.from((Callback)callback, () -> this._remotes.computeIfPresent(remote._ip, (k, v) -> v._referenceCounter.release() ? null : v)));
        limitedRequest.handle();
        return true;
    }

    @Override
    protected boolean onConditionsNotMet(Request request, Response response, Callback callback) throws Exception {
        return this.nextHandler(request, response, callback);
    }

    private Remote getRemote(Request baseRequest) {
        String ip = this.getRemoteIP(baseRequest);
        if (LOG.isDebugEnabled()) {
            LOG.debug("ip={}", (Object)ip);
        }
        if (ip == null) {
            return null;
        }
        int limit = this.getThreadLimit(ip);
        if (limit <= 0) {
            return null;
        }
        return this._remotes.compute(ip, (k, v) -> {
            if (v != null) {
                v._referenceCounter.retain();
                return v;
            }
            return new Remote(baseRequest.getContext(), (String)k, limit);
        });
    }

    protected String getRemoteIP(Request baseRequest) {
        InetSocketAddress inetAddr;
        SocketAddress socketAddress;
        if (this._forwardedHeader != null && !this._forwardedHeader.isEmpty()) {
            String remote;
            String string = remote = this._rfc7239 ? this.getForwarded(baseRequest) : this.getXForwardedFor(baseRequest);
            if (remote != null && !remote.isEmpty()) {
                return remote;
            }
        }
        if ((socketAddress = baseRequest.getConnectionMetaData().getRemoteSocketAddress()) instanceof InetSocketAddress && (inetAddr = (InetSocketAddress)socketAddress).getAddress() != null) {
            return inetAddr.getAddress().getHostAddress();
        }
        return null;
    }

    private String getForwarded(Request request) {
        RFC7239 rfc7239 = new RFC7239();
        for (HttpField field : request.getHeaders()) {
            if (!this._forwardedHeader.equalsIgnoreCase(field.getName())) continue;
            rfc7239.addValue(field.getValue());
        }
        if (rfc7239.getFor() != null) {
            return new HostPortHttpField(rfc7239.getFor()).getHost();
        }
        return null;
    }

    private String getXForwardedFor(Request request) {
        String forwardedFor = null;
        for (HttpField field : request.getHeaders()) {
            if (!this._forwardedHeader.equalsIgnoreCase(field.getName())) continue;
            forwardedFor = field.getValue();
        }
        if (forwardedFor == null || forwardedFor.isEmpty()) {
            return null;
        }
        int comma = forwardedFor.lastIndexOf(44);
        return comma >= 0 ? forwardedFor.substring(comma + 1).trim() : forwardedFor;
    }

    int getRemoteCount() {
        return this._remotes.size();
    }

    private static final class Remote {
        private final Executor _executor;
        private final Retainable.ReferenceCounter _referenceCounter = new Retainable.ReferenceCounter();
        private final String _ip;
        private final int _limit;
        private final AutoLock _lock = new AutoLock();
        private int _permits;
        private final Deque<FuturePermit> _queue = new ArrayDeque<FuturePermit>();
        private final Permit _permitted = new AllocatedPermit(this);
        private final ThreadLocal<Boolean> _threadPermit = new ThreadLocal();
        private static final Permit NOOP = new NoopPermit();

        public Remote(Executor executor, String ip, int limit) {
            this._executor = executor;
            this._ip = ip;
            this._limit = limit;
        }

        Permit acquire() {
            try (AutoLock lock = this._lock.lock();){
                if (this._threadPermit.get() == Boolean.TRUE) {
                    Permit permit = NOOP;
                    return permit;
                }
                if (this._permits < this._limit) {
                    ++this._permits;
                    this._threadPermit.set(Boolean.TRUE);
                    Permit permit = this._permitted;
                    return permit;
                }
                FuturePermit futurePermit = new FuturePermit(this);
                this._queue.addLast(futurePermit);
                FuturePermit futurePermit2 = futurePermit;
                return futurePermit2;
            }
        }

        public void release() {
            FuturePermit pending;
            try (AutoLock lock = this._lock.lock();){
                --this._permits;
                this._threadPermit.set(Boolean.FALSE);
                pending = this._queue.pollFirst();
                if (pending != null) {
                    ++this._permits;
                }
            }
            if (pending != null) {
                this._executor.execute(pending::complete);
            }
        }

        public String toString() {
            try (AutoLock lock = this._lock.lock();){
                String string = String.format("R[ip=%s,p=%d,l=%d,q=%d]", this._ip, this._permits, this._limit, this._queue.size());
                return string;
            }
        }
    }

    private static class LimitedRequest
    extends Request.Wrapper {
        private final Remote _remote;
        private final Request.Handler _handler;
        private final LimitedResponse _response;
        private final Callback _callback;
        private final AtomicReference<Runnable> _onContent = new AtomicReference();

        public LimitedRequest(Remote remote, Request.Handler handler, Request request, Response response, Callback callback) {
            super(request);
            this._remote = remote;
            this._handler = Objects.requireNonNull(handler);
            this._response = new LimitedResponse(this, response);
            this._callback = Objects.requireNonNull(callback);
        }

        protected Request.Handler getHandler() {
            return this._handler;
        }

        protected Response getResponse() {
            return this._response;
        }

        protected Callback getCallback() {
            return this._callback;
        }

        protected void handle() {
            Permit permit = this._remote.acquire();
            if (permit.isAllocated()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Thread permitted {} {} {}", new Object[]{this._remote, this.getWrapped(), this.getHandler()});
                }
                this.handle(permit);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Thread limited {} {} {}", new Object[]{this._remote, this.getWrapped(), this.getHandler()});
                }
                permit.whenAllocated(this::handle);
            }
        }

        protected void handle(Permit permit) {
            try {
                if (!this.getHandler().handle(this, this.getResponse(), this.getCallback())) {
                    Response.writeError((Request)this, this.getResponse(), this.getCallback(), 404);
                }
            }
            catch (Throwable x) {
                this.getCallback().failed(x);
            }
            finally {
                permit.release();
            }
        }

        @Override
        public void demand(Runnable onContent) {
            if (!this._onContent.compareAndSet(null, Objects.requireNonNull(onContent))) {
                throw new IllegalStateException("Pending demand");
            }
            super.demand((Runnable)((Object)new DemandTask(Invocable.getInvocationType((Object)onContent))));
        }

        private void onContent() {
            Permit permit = this._remote.acquire();
            if (permit.isAllocated()) {
                this.onPermittedContent(permit);
            } else {
                permit.whenAllocated(this::onPermittedContent);
            }
        }

        private void onPermittedContent(Permit permit) {
            try {
                Runnable onContent = this._onContent.getAndSet(null);
                onContent.run();
            }
            finally {
                permit.release();
            }
        }

        private class DemandTask
        extends Invocable.Task.Abstract {
            private DemandTask(Invocable.InvocationType invocationType) {
                super(invocationType);
            }

            public void run() {
                LimitedRequest.this.onContent();
            }
        }
    }

    private static final class RFC7239
    extends QuotedCSV {
        String _for;

        private RFC7239() {
            super(false, new String[0]);
        }

        String getFor() {
            return this._for;
        }

        protected void parsedParam(StringBuilder buffer, int valueLength, int paramName, int paramValue) {
            String name;
            if (valueLength == 0 && paramValue > paramName && "for".equalsIgnoreCase(name = StringUtil.asciiToLowerCase((String)buffer.substring(paramName, paramValue - 1)))) {
                String value = buffer.substring(paramValue);
                this._for = "unknown".equalsIgnoreCase(value) ? null : value;
            }
        }
    }

    private static class FuturePermit
    implements Permit {
        private final CompletableFuture<Permit> _future = new CompletableFuture();
        private final Remote _remote;

        private FuturePermit(Remote remote) {
            this._remote = remote;
        }

        @Override
        public boolean isAllocated() {
            return this._future.isDone();
        }

        @Override
        public void whenAllocated(Consumer<Permit> permitConsumer) {
            this._future.thenAccept((Consumer)permitConsumer);
        }

        void complete() {
            if (!this._future.complete(this)) {
                throw new IllegalStateException();
            }
        }

        @Override
        public void release() {
            this._remote.release();
        }
    }

    private static class AllocatedPermit
    implements Permit {
        private final Remote _remote;

        private AllocatedPermit(Remote remote) {
            this._remote = remote;
        }

        @Override
        public boolean isAllocated() {
            return true;
        }

        @Override
        public void whenAllocated(Consumer<Permit> permitConsumer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void release() {
            this._remote.release();
        }

        public String toString() {
            return "AllocatedPermit:" + String.valueOf(this._remote);
        }
    }

    private static class NoopPermit
    implements Permit {
        private NoopPermit() {
        }

        @Override
        public boolean isAllocated() {
            return true;
        }

        @Override
        public void whenAllocated(Consumer<Permit> permitConsumer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void release() {
        }
    }

    private static interface Permit {
        public boolean isAllocated();

        public void whenAllocated(Consumer<Permit> var1);

        public void release();
    }

    private static class LimitedResponse
    extends Response.Wrapper
    implements Callback {
        private final Remote _remote;
        private final AtomicReference<Callback> _writeCallback = new AtomicReference();

        public LimitedResponse(LimitedRequest limitedRequest, Response response) {
            super(limitedRequest, response);
            this._remote = limitedRequest._remote;
        }

        @Override
        public void write(boolean last, ByteBuffer byteBuffer, Callback callback) {
            if (!this._writeCallback.compareAndSet(null, Objects.requireNonNull(callback))) {
                throw new WritePendingException();
            }
            super.write(last, byteBuffer, this);
        }

        public void succeeded() {
            Permit permit = this._remote.acquire();
            if (permit.isAllocated()) {
                this.permittedSuccess(permit);
            } else {
                permit.whenAllocated(this::permittedSuccess);
            }
        }

        private void permittedSuccess(Permit permit) {
            try {
                ((Callback)this._writeCallback.getAndSet(null)).succeeded();
            }
            finally {
                permit.release();
            }
        }

        public void failed(Throwable x) {
            Permit permit = this._remote.acquire();
            if (permit.isAllocated()) {
                this.permittedFailure(permit, x);
            } else {
                permit.whenAllocated(p -> this.permittedFailure((Permit)p, x));
            }
        }

        private void permittedFailure(Permit permit, Throwable x) {
            try {
                ((Callback)this._writeCallback.getAndSet(null)).failed(x);
            }
            finally {
                permit.release();
            }
        }

        public Invocable.InvocationType getInvocationType() {
            return Invocable.getInvocationType((Object)this._writeCallback.get());
        }
    }
}

