/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.util.concurrent.Future;
import org.jspecify.annotations.Nullable;
import org.junit.platform.engine.CancellationToken;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.support.hierarchical.EngineExecutionContext;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestExecutorService;
import org.junit.platform.engine.support.hierarchical.NodeExecutionAdvisor;
import org.junit.platform.engine.support.hierarchical.NodeTestTask;
import org.junit.platform.engine.support.hierarchical.NodeTestTaskContext;
import org.junit.platform.engine.support.hierarchical.NodeTreeWalker;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

class HierarchicalTestExecutor<C extends EngineExecutionContext> {
    private final ExecutionRequest request;
    private final C rootContext;
    private final HierarchicalTestExecutorService executorService;
    private final ThrowableCollector.Factory throwableCollectorFactory;

    HierarchicalTestExecutor(ExecutionRequest request, C rootContext, HierarchicalTestExecutorService executorService, ThrowableCollector.Factory throwableCollectorFactory) {
        this.request = request;
        this.rootContext = rootContext;
        this.executorService = executorService;
        this.throwableCollectorFactory = throwableCollectorFactory;
    }

    Future<@Nullable Void> execute() {
        return this.executorService.submit(this.createRootTestTask());
    }

    private NodeTestTask<C> createRootTestTask() {
        NodeTestTaskContext taskContext = this.createTaskContext();
        TestDescriptor rootTestDescriptor = this.request.getRootTestDescriptor();
        NodeTestTask<C> rootTestTask = new NodeTestTask<C>(taskContext, rootTestDescriptor);
        rootTestTask.setParentContext(this.rootContext);
        return rootTestTask;
    }

    private NodeTestTaskContext createTaskContext() {
        EngineExecutionListener executionListener = this.request.getEngineExecutionListener();
        NodeExecutionAdvisor executionAdvisor = new NodeTreeWalker().walk(this.request.getRootTestDescriptor());
        CancellationToken cancellationToken = this.request.getCancellationToken();
        return new NodeTestTaskContext(executionListener, this.executorService, this.throwableCollectorFactory, executionAdvisor, cancellationToken);
    }
}

