/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.java.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation;
import org.eclipse.wst.jsdt.web.core.javascript.JsTranslationAdapter;
import org.eclipse.wst.jsdt.web.ui.internal.java.search.JsSearchQuery;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.search.FindOccurrencesProcessor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class JsFindOccurrencesProcessor
extends FindOccurrencesProcessor {
    private IJavaScriptElement getJavaElement(IDocument document, ITextSelection textSelection) {
        IJavaScriptElement[] elements = this.getJavaElementsForCurrentSelection(document, textSelection);
        return elements.length > 0 ? elements[0] : null;
    }

    private IJavaScriptElement[] getJavaElementsForCurrentSelection(IDocument document, ITextSelection selection) {
        IJavaScriptElement[] elements = new IJavaScriptElement[]{};
        IStructuredModel model = null;
        try {
            IDOMDocument xmlDoc;
            JsTranslationAdapter adapter;
            model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            if (model != null && model instanceof IDOMModel && (adapter = (JsTranslationAdapter)(xmlDoc = ((IDOMModel)model).getDocument()).getAdapterFor(IJsTranslation.class)) != null) {
                IJsTranslation translation = adapter.getJsTranslation(false);
                elements = translation.getElementsFromJsRange(translation.getJavaScriptOffset(selection.getOffset()), translation.getJavaScriptOffset(selection.getOffset() + selection.getLength()));
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return elements;
    }

    protected String[] getPartitionTypes() {
        return new String[]{"org.eclipse.wst.html.SCRIPT"};
    }

    protected String[] getRegionTypes() {
        return new String[]{"BLOCK_TEXT"};
    }

    protected ISearchQuery getSearchQuery(IFile file, IStructuredDocument document, String regionText, String regionType, ITextSelection textSelection) {
        IJavaScriptElement javaScriptElement = this.getJavaElement((IDocument)document, textSelection);
        if (javaScriptElement != null) {
            return new JsSearchQuery(file, javaScriptElement);
        }
        return null;
    }
}

