/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.debug.ui;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.workbench.browser.BrowserUtil;
import org.eclipse.mylyn.internal.debug.ui.DebugUiPlugin;
import org.eclipse.mylyn.internal.debug.ui.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class BreakpointsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button manageBreakpointsButton;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Label infoImage = new Label(composite, 0);
        infoImage.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.INFORMATION));
        Link bugLink = new Link(composite, 0);
        bugLink.setText(Messages.BreakpointsPreferencePage_bug_link);
        bugLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserUtil.openUrl((String)"https://bugs.eclipse.org/bugs/show_bug.cgi?id=428378");
            }
        });
        this.manageBreakpointsButton = new Button(composite, 32);
        this.manageBreakpointsButton.setText(Messages.BreakpointsPreferencePage_Manage_breakpoints);
        this.manageBreakpointsButton.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.context.breakpoints.auto.manage"));
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.manageBreakpointsButton);
        Group warningGroup = new Group(composite, 16);
        warningGroup.setLayout((Layout)new GridLayout(1, false));
        warningGroup.setLayoutData((Object)new GridData(768));
        warningGroup.setText(Messages.BreakpointsPreferencePage_Known_Issues);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo((Composite)warningGroup);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)warningGroup);
        this.createWarning((Composite)warningGroup, Messages.Breakpoints_closed_projects_warning);
        this.createWarning((Composite)warningGroup, Messages.Breakpoints_locations_warning);
        this.createWarning((Composite)warningGroup, Messages.BreakpointsPreferencePage_unchecking_will_remove);
        return composite;
    }

    private void createWarning(Composite parent, String message) {
        Label warningImage = new Label(parent, 0);
        warningImage.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.WARNING));
        Label warningMessage = new Label(parent, 0);
        warningMessage.setText(message);
        GridDataFactory.swtDefaults().align(0x1000000, 1).applyTo((Control)warningImage);
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("org.eclipse.mylyn.context.breakpoints.auto.manage", this.manageBreakpointsButton.getSelection());
        return true;
    }

    protected void performDefaults() {
        this.manageBreakpointsButton.setSelection(false);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return DebugUiPlugin.getDefault().getPreferenceStore();
    }
}

