/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.core.ast.nodes.DefaultBindingResolver;
import org.eclipse.php.core.ast.nodes.IMethodBinding;
import org.eclipse.php.core.ast.nodes.ITypeBinding;
import org.eclipse.php.core.ast.nodes.IVariableBinding;

public class MultiTypeBinding
implements ITypeBinding {
    private final ITypeBinding[] subtypes;
    private final DefaultBindingResolver resolver;

    public MultiTypeBinding(DefaultBindingResolver resolver, ITypeBinding[] subtypes) {
        this.subtypes = subtypes;
        this.resolver = resolver;
    }

    @Override
    public int getKind() {
        return 2;
    }

    @Override
    public boolean isDeprecated() {
        ITypeBinding[] iTypeBindingArray = this.subtypes;
        int n = this.subtypes.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding binding = iTypeBindingArray[n2];
            if (binding.isDeprecated()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public IModelElement getPHPElement() {
        return null;
    }

    @Override
    public String getKey() {
        return null;
    }

    @Override
    public ITypeBinding createArrayType(int dimension) {
        return null;
    }

    @Override
    public String getBinaryName() {
        return null;
    }

    @Override
    public ITypeBinding getComponentType() {
        return null;
    }

    @Override
    public IVariableBinding[] getDeclaredFields() {
        LinkedList<IVariableBinding> list = new LinkedList<IVariableBinding>();
        ITypeBinding[] iTypeBindingArray = this.subtypes;
        int n = this.subtypes.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding t = iTypeBindingArray[n2];
            list.addAll(Arrays.asList(t.getDeclaredFields()));
            ++n2;
        }
        return list.toArray(new IVariableBinding[0]);
    }

    @Override
    public IMethodBinding[] getDeclaredMethods() {
        LinkedList<IMethodBinding> list = new LinkedList<IMethodBinding>();
        ITypeBinding[] iTypeBindingArray = this.subtypes;
        int n = this.subtypes.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding t = iTypeBindingArray[n2];
            list.addAll(Arrays.asList(t.getDeclaredMethods()));
            ++n2;
        }
        return list.toArray(new IMethodBinding[0]);
    }

    @Override
    public int getModifiers() {
        return -1;
    }

    @Override
    public int getDimensions() {
        return 0;
    }

    @Override
    public ITypeBinding getElementType() {
        return null;
    }

    @Override
    public ITypeBinding[] getInterfaces() {
        LinkedList<ITypeBinding> list = new LinkedList<ITypeBinding>();
        ITypeBinding[] iTypeBindingArray = this.subtypes;
        int n = this.subtypes.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding t = iTypeBindingArray[n2];
            list.addAll(Arrays.asList(t.getInterfaces()));
            ++n2;
        }
        return list.toArray(new ITypeBinding[0]);
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public IEvaluatedType getEvaluatedType() {
        return this.subtypes[0].getEvaluatedType();
    }

    @Override
    public ITypeBinding getSuperclass() {
        LinkedList<ITypeBinding> list = new LinkedList<ITypeBinding>();
        ITypeBinding[] iTypeBindingArray = this.subtypes;
        int n = this.subtypes.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding t = iTypeBindingArray[n2];
            ITypeBinding s = t.getSuperclass();
            if (s != null && !s.isUnknown()) {
                list.add(s);
            }
            ++n2;
        }
        if (list.size() == 1) {
            return (ITypeBinding)list.get(0);
        }
        if (list.size() > 1) {
            return new MultiTypeBinding(this.resolver, list.toArray(new ITypeBinding[0]));
        }
        return null;
    }

    @Override
    public ITypeBinding getTypeDeclaration() {
        return this.subtypes[0].getTypeDeclaration();
    }

    @Override
    public boolean isArray() {
        ITypeBinding[] iTypeBindingArray = this.subtypes;
        int n = this.subtypes.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding t = iTypeBindingArray[n2];
            if (t.isArray()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isClass() {
        ITypeBinding[] iTypeBindingArray = this.subtypes;
        int n = this.subtypes.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding t = iTypeBindingArray[n2];
            if (t.isClass()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isTrait() {
        ITypeBinding[] iTypeBindingArray = this.subtypes;
        int n = this.subtypes.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding t = iTypeBindingArray[n2];
            if (t.isTrait()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isInterface() {
        ITypeBinding[] iTypeBindingArray = this.subtypes;
        int n = this.subtypes.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding t = iTypeBindingArray[n2];
            if (t.isInterface()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isEnum() {
        ITypeBinding[] iTypeBindingArray = this.subtypes;
        int n = this.subtypes.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding t = iTypeBindingArray[n2];
            if (t.isEnum()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isNullType() {
        ITypeBinding[] iTypeBindingArray = this.subtypes;
        int n = this.subtypes.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding t = iTypeBindingArray[n2];
            if (t.isNullType()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isPrimitive() {
        ITypeBinding[] iTypeBindingArray = this.subtypes;
        int n = this.subtypes.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding t = iTypeBindingArray[n2];
            if (t.isPrimitive()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isSubTypeCompatible(ITypeBinding type) {
        ITypeBinding[] iTypeBindingArray = this.subtypes;
        int n = this.subtypes.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding t = iTypeBindingArray[n2];
            if (t.isSubTypeCompatible(type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isAmbiguous() {
        return true;
    }

    @Override
    public boolean isUnknown() {
        return false;
    }

    @Override
    public List<IType> getTraitList(boolean isMethod, String classMemberName, boolean includeSuper) {
        LinkedList<IType> list = new LinkedList<IType>();
        ITypeBinding[] iTypeBindingArray = this.subtypes;
        int n = this.subtypes.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding t = iTypeBindingArray[n2];
            list.addAll(t.getTraitList(isMethod, classMemberName, includeSuper));
            ++n2;
        }
        return list;
    }

    @Override
    public IModelElement[] getPHPElements() {
        LinkedList<IModelElement> list = new LinkedList<IModelElement>();
        ITypeBinding[] iTypeBindingArray = this.subtypes;
        int n = this.subtypes.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding t = iTypeBindingArray[n2];
            list.addAll(Arrays.asList(t.getPHPElements()));
            ++n2;
        }
        return list.toArray(new IModelElement[0]);
    }
}

