/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.registry.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.registry.IGrammarDefinition;
import org.eclipse.tm4e.registry.IGrammarRegistryManager;
import org.eclipse.tm4e.registry.ITMScope;
import org.eclipse.tm4e.registry.internal.AbstractGrammarRegistryManager;
import org.eclipse.tm4e.registry.internal.GrammarRegistryManager;
import org.osgi.service.prefs.BackingStoreException;

class WorkingCopyGrammarRegistryManager
extends AbstractGrammarRegistryManager
implements IGrammarRegistryManager.EditSession {
    private final GrammarRegistryManager manager;
    private final Set<IGrammarDefinition> added = new HashSet<IGrammarDefinition>();
    private final Set<IGrammarDefinition> removed = new HashSet<IGrammarDefinition>();
    private boolean isDirty = false;

    WorkingCopyGrammarRegistryManager(GrammarRegistryManager manager) {
        this.manager = manager;
        this.reset();
    }

    @Override
    public void reset() {
        this.pluginDefinitions.byQualifiedScopeName.clear();
        this.pluginDefinitions.byQualifiedScopeName.putAll(this.manager.pluginDefinitions.byQualifiedScopeName);
        this.pluginDefinitions.byUnqualifiedScopeName.clear();
        this.pluginDefinitions.byUnqualifiedScopeName.putAll(this.manager.pluginDefinitions.byUnqualifiedScopeName);
        this.userDefinitions.byQualifiedScopeName.clear();
        this.userDefinitions.byQualifiedScopeName.putAll(this.manager.userDefinitions.byQualifiedScopeName);
        this.userDefinitions.byUnqualifiedScopeName.clear();
        this.userDefinitions.byUnqualifiedScopeName.putAll(this.manager.userDefinitions.byUnqualifiedScopeName);
        this.added.clear();
        this.removed.clear();
        this.isDirty = false;
    }

    @Override
    public @Nullable Collection<IContentType> getContentTypesForScope(ITMScope scope) {
        return this.manager.getContentTypesForScope(scope);
    }

    @Override
    public @Nullable Collection<String> getInjections(String scopeName) {
        return this.manager.getInjections(scopeName);
    }

    @Override
    public @Nullable Collection<String> getInjections(ITMScope scope) {
        return this.manager.getInjections(scope);
    }

    @Override
    public void registerGrammarDefinition(IGrammarDefinition definition) {
        super.registerGrammarDefinition(definition);
        this.removed.remove(definition);
        this.added.add(definition);
        this.isDirty = true;
    }

    @Override
    public void unregisterGrammarDefinition(IGrammarDefinition definition) {
        super.unregisterGrammarDefinition(definition);
        this.added.remove(definition);
        this.removed.add(definition);
        this.isDirty = true;
    }

    @Override
    public void save() throws BackingStoreException {
        if (!this.isDirty) {
            return;
        }
        this.removed.forEach(this.manager::unregisterGrammarDefinition);
        this.added.forEach(this.manager::registerGrammarDefinition);
        this.manager.save();
        this.reset();
    }
}

