/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.expressions;

import org.eclipse.debug.internal.core.WatchExpression;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.viewers.model.VirtualCopyToClipboardActionDelegate;

public class CopyExpressionsToClipboardActionDelegate
extends VirtualCopyToClipboardActionDelegate {
    private static final String QUOTE = "\"";

    @Override
    protected String trimLabel(String rawLabel) {
        String label = super.trimLabel(rawLabel);
        if (label == null) {
            return null;
        }
        if (label.startsWith(QUOTE)) {
            label = label.substring(1);
        }
        if (label.endsWith(QUOTE)) {
            label = label.substring(0, label.length() - 1);
        }
        return label;
    }

    @Override
    protected String exludeLabels(Object itemData, String label) {
        if (itemData instanceof WatchExpression) {
            WatchExpression watchExp = (WatchExpression)itemData;
            if ((watchExp.isPending() || watchExp.hasErrors()) && (label.equals(DebugUIMessages.DefaultLabelProvider_12) || label.contains(DebugUIMessages.DefaultLabelProvider_13))) {
                return null;
            }
            if (!watchExp.isEnabled()) {
                if (label.equals(DebugUIMessages.DefaultLabelProvider_15)) {
                    return null;
                }
                int index = label.lastIndexOf(DebugUIMessages.DefaultLabelProvider_15);
                if (index != -1) {
                    label = label.substring(0, index);
                }
            }
        }
        return label;
    }
}

