/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import org.eclipse.jdt.internal.debug.ui.JavaDebugImages;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.Point;

public class JDIImageDescriptor
extends CompositeImageDescriptor {
    public static final int IS_OUT_OF_SYNCH = 1;
    public static final int MAY_BE_OUT_OF_SYNCH = 2;
    public static final int INSTALLED = 4;
    public static final int ENTRY = 8;
    public static final int EXIT = 16;
    public static final int ENABLED = 32;
    public static final int CONDITIONAL = 64;
    public static final int CAUGHT = 128;
    public static final int UNCAUGHT = 256;
    public static final int SCOPED = 512;
    public static final int OWNS_MONITOR = 1024;
    public static final int OWNED_MONITOR = 2048;
    public static final int CONTENTED_MONITOR = 4096;
    public static final int IN_CONTENTION_FOR_MONITOR = 8192;
    public static final int IN_DEADLOCK = 32768;
    public static final int SYNCHRONIZED = 16384;
    public static final int TRIGGER_POINT = 65536;
    public static final int TRIGGER_SUPPRESSED = 131072;
    public static final int LOGICAL_STRUCTURE = 0x400000;
    private ImageDescriptor fBaseImage;
    private int fFlags;
    private Point fSize;

    public JDIImageDescriptor(ImageDescriptor baseImage, int flags) {
        this.setBaseImage(baseImage);
        this.setFlags(flags);
    }

    protected Point getSize() {
        if (this.fSize == null) {
            CompositeImageDescriptor.CachedImageDataProvider provider = this.createCachedImageDataProvider(this.getBaseImage());
            this.setSize(new Point(provider.getWidth(), provider.getHeight()));
        }
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JDIImageDescriptor)) {
            return false;
        }
        JDIImageDescriptor other = (JDIImageDescriptor)((Object)object);
        return this.getBaseImage().equals(other.getBaseImage()) && this.getFlags() == other.getFlags();
    }

    public int hashCode() {
        return this.getBaseImage().hashCode() | this.getFlags();
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage((ImageDataProvider)this.createCachedImageDataProvider(this.getBaseImage()), 0, 0);
        this.drawOverlays();
    }

    private ImageDescriptor getImageDescriptor(String imageDescriptorKey) {
        return JavaDebugImages.getImageDescriptor(imageDescriptorKey);
    }

    protected void drawOverlays() {
        int flags = this.getFlags();
        int x = 0;
        int y = 0;
        if ((flags & 1) != 0) {
            x = this.getSize().x;
            y = 0;
            CompositeImageDescriptor.CachedImageDataProvider provider = this.createCachedImageDataProvider(this.getImageDescriptor("IMG_OVR_OUT_OF_SYNCH"));
            this.drawImage((ImageDataProvider)provider, x -= provider.getWidth(), y);
        } else if ((flags & 2) != 0) {
            x = this.getSize().x;
            y = 0;
            CompositeImageDescriptor.CachedImageDataProvider provider = this.createCachedImageDataProvider(this.getImageDescriptor("IMG_OVR_MAY_BE_OUT_OF_SYNCH"));
            this.drawImage((ImageDataProvider)provider, x -= provider.getWidth(), y);
        } else if ((flags & 0x4000) != 0) {
            x = this.getSize().x;
            y = 0;
            CompositeImageDescriptor.CachedImageDataProvider provider = this.createCachedImageDataProvider(this.getImageDescriptor("IMG_OVR_SYNCHRONIZED"));
            this.drawImage((ImageDataProvider)provider, x -= provider.getWidth(), y);
        } else {
            CompositeImageDescriptor.CachedImageDataProvider provider;
            if ((flags & 0x8000) != 0) {
                x = 0;
                y = 0;
                provider = this.createCachedImageDataProvider(this.getImageDescriptor("IMG_OVR_IN_DEADLOCK"));
                this.drawImage((ImageDataProvider)provider, x, y);
            }
            if ((flags & 0x10000) != 0) {
                x = this.getSize().x;
                y = this.getSize().y;
                provider = this.createCachedImageDataProvider(this.getImageDescriptor("IMG_OVR_IN_TRIGGER_POINT"));
                this.drawImage((ImageDataProvider)provider, x -= provider.getWidth(), y -= provider.getHeight());
            } else if ((flags & 0x20000) != 0) {
                x = this.getSize().x;
                y = this.getSize().y;
                provider = this.createCachedImageDataProvider(this.getImageDescriptor("IMG_OVR_TRIGGER_SUPPRESSED"));
                this.drawImage((ImageDataProvider)provider, x -= provider.getWidth(), y -= provider.getHeight());
            }
            if ((flags & 0x800) != 0) {
                x = this.getSize().x;
                y = this.getSize().y;
                provider = this.createCachedImageDataProvider(this.getImageDescriptor("IMG_OVR_OWNED"));
                this.drawImage((ImageDataProvider)provider, x -= provider.getWidth(), y -= provider.getHeight());
            } else if ((flags & 0x1000) != 0) {
                x = this.getSize().x;
                y = this.getSize().y;
                provider = this.createCachedImageDataProvider(this.getImageDescriptor("IMG_OVR_IN_CONTENTION"));
                this.drawImage((ImageDataProvider)provider, x -= provider.getWidth(), y -= provider.getHeight());
            } else if ((flags & 0x400) != 0) {
                x = this.getSize().x;
                y = 0;
                provider = this.createCachedImageDataProvider(this.getImageDescriptor("IMG_OVR_OWNS_MONITOR"));
                this.drawImage((ImageDataProvider)provider, x -= provider.getWidth(), y);
            } else if ((flags & 0x2000) != 0) {
                x = this.getSize().x;
                y = 0;
                provider = this.createCachedImageDataProvider(this.getImageDescriptor("IMG_OVR_IN_CONTENTION_FOR_MONITOR"));
                this.drawImage((ImageDataProvider)provider, x -= provider.getWidth(), y);
            } else {
                this.drawBreakpointOverlays();
            }
        }
    }

    protected void drawBreakpointOverlays() {
        CompositeImageDescriptor.CachedImageDataProvider provider;
        int flags = this.getFlags();
        int x = 0;
        int y = 0;
        if ((flags & 4) != 0) {
            x = 0;
            y = this.getSize().y;
            provider = (flags & 0x20) != 0 ? this.createCachedImageDataProvider(this.getImageDescriptor("IMG_OBJS_BREAKPOINT_INSTALLED")) : this.createCachedImageDataProvider(this.getImageDescriptor("IMG_OBJS_BREAKPOINT_INSTALLED_DISABLED"));
            this.drawImage((ImageDataProvider)provider, x, y -= provider.getHeight());
        }
        if ((flags & 0x80) != 0) {
            provider = (flags & 0x20) != 0 ? this.createCachedImageDataProvider(this.getImageDescriptor("IMG_OBJS_CAUGHT_BREAKPOINT")) : this.createCachedImageDataProvider(this.getImageDescriptor("IMG_OBJS_CAUGHT_BREAKPOINT_DISABLED"));
            x = 0;
            y = 0;
            this.drawImage((ImageDataProvider)provider, x, y);
        }
        if ((flags & 0x100) != 0) {
            provider = (flags & 0x20) != 0 ? this.createCachedImageDataProvider(this.getImageDescriptor("IMG_OBJS_UNCAUGHT_BREAKPOINT")) : this.createCachedImageDataProvider(this.getImageDescriptor("IMG_OBJS_UNCAUGHT_BREAKPOINT_DISABLED"));
            x = provider.getWidth();
            y = provider.getHeight();
            this.drawImage((ImageDataProvider)provider, x, y);
        }
        if ((flags & 0x200) != 0) {
            provider = (flags & 0x20) != 0 ? this.createCachedImageDataProvider(this.getImageDescriptor("IMG_OBJS_SCOPED_BREAKPOINT")) : this.createCachedImageDataProvider(this.getImageDescriptor("IMG_OBJS_SCOPED_BREAKPOINT_DISABLED"));
            x = 0;
            y = this.getSize().y;
            this.drawImage((ImageDataProvider)provider, x, y -= provider.getHeight());
        }
        if ((flags & 0x40) != 0) {
            provider = (flags & 0x20) != 0 ? this.createCachedImageDataProvider(this.getImageDescriptor("IMG_OBJS_CONDITIONAL_BREAKPOINT")) : this.createCachedImageDataProvider(this.getImageDescriptor("IMG_OBJS_CONDITIONAL_BREAKPOINT_DISABLED"));
            x = 0;
            y = 0;
            this.drawImage((ImageDataProvider)provider, x, y);
        }
        if ((flags & 8) != 0) {
            x = this.getSize().x;
            y = 0;
            provider = (flags & 0x20) != 0 ? this.createCachedImageDataProvider(this.getImageDescriptor("IMG_OBJS_METHOD_BREAKPOINT_ENTRY")) : this.createCachedImageDataProvider(this.getImageDescriptor("IMG_OBJS_METHOD_BREAKPOINT_ENTRY_DISABLED"));
            x -= provider.getWidth();
            this.drawImage((ImageDataProvider)provider, x -= 2, y);
        }
        if ((flags & 0x10) != 0) {
            x = this.getSize().x;
            y = this.getSize().y;
            provider = (flags & 0x20) != 0 ? this.createCachedImageDataProvider(this.getImageDescriptor("IMG_OBJS_METHOD_BREAKPOINT_EXIT")) : this.createCachedImageDataProvider(this.getImageDescriptor("IMG_OBJS_METHOD_BREAKPOINT_EXIT_DISABLED"));
            x -= provider.getWidth();
            this.drawImage((ImageDataProvider)provider, x -= 2, y -= provider.getHeight());
        }
    }

    protected ImageDescriptor getBaseImage() {
        return this.fBaseImage;
    }

    protected void setBaseImage(ImageDescriptor baseImage) {
        this.fBaseImage = baseImage;
    }

    protected int getFlags() {
        return this.fFlags;
    }

    protected void setFlags(int flags) {
        this.fFlags = flags;
    }

    protected void setSize(Point size) {
        this.fSize = size;
    }
}

